/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Pair;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.cordova.CallbackMap;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CoreAndroid;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.ResumeCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class CordovaInterfaceImpl
implements CordovaInterface {
    private static final String TAG = "CordovaInterfaceImpl";
    protected Activity activity;
    protected ExecutorService threadPool;
    protected PluginManager pluginManager;
    protected ActivityResultHolder savedResult;
    protected CallbackMap permissionResultCallbacks;
    protected CordovaPlugin activityResultCallback;
    protected String initCallbackService;
    protected int activityResultRequestCode;
    protected boolean activityWasDestroyed = false;
    protected Bundle savedPluginState;

    public CordovaInterfaceImpl(Activity activity) {
        this(activity, Executors.newCachedThreadPool());
    }

    public CordovaInterfaceImpl(Activity activity, ExecutorService executorService) {
        this.activity = activity;
        this.threadPool = executorService;
        this.permissionResultCallbacks = new CallbackMap();
    }

    @Override
    public void startActivityForResult(CordovaPlugin cordovaPlugin, Intent intent, int n2) {
        this.setActivityResultCallback(cordovaPlugin);
        try {
            this.activity.startActivityForResult(intent, n2);
        }
        catch (RuntimeException runtimeException) {
            this.activityResultCallback = null;
            throw runtimeException;
        }
    }

    @Override
    public void setActivityResultCallback(CordovaPlugin cordovaPlugin) {
        if (this.activityResultCallback != null) {
            this.activityResultCallback.onActivityResult(this.activityResultRequestCode, 0, null);
        }
        this.activityResultCallback = cordovaPlugin;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public Context getContext() {
        return this.activity;
    }

    @Override
    public Object onMessage(String string2, Object object) {
        if ("exit".equals(string2)) {
            this.activity.finish();
        }
        return null;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void onCordovaInit(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        if (this.savedResult != null) {
            this.onActivityResult(this.savedResult.requestCode, this.savedResult.resultCode, this.savedResult.intent);
        } else if (this.activityWasDestroyed) {
            CoreAndroid coreAndroid;
            this.activityWasDestroyed = false;
            if (pluginManager != null && (coreAndroid = (CoreAndroid)pluginManager.getPlugin("CoreAndroid")) != null) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("action", (Object)"resume");
                }
                catch (JSONException jSONException) {
                    LOG.e(TAG, "Failed to create event message", jSONException);
                }
                coreAndroid.sendResumeEvent(new PluginResult(PluginResult.Status.OK, jSONObject));
            }
        }
    }

    public boolean onActivityResult(int n2, int n3, Intent intent) {
        CordovaPlugin cordovaPlugin = this.activityResultCallback;
        if (cordovaPlugin == null && this.initCallbackService != null) {
            this.savedResult = new ActivityResultHolder(n2, n3, intent);
            if (this.pluginManager != null && (cordovaPlugin = this.pluginManager.getPlugin(this.initCallbackService)) != null) {
                cordovaPlugin.onRestoreStateForActivityResult(this.savedPluginState.getBundle(cordovaPlugin.getServiceName()), new ResumeCallback(cordovaPlugin.getServiceName(), this.pluginManager));
            }
        }
        this.activityResultCallback = null;
        if (cordovaPlugin != null) {
            LOG.d(TAG, "Sending activity result to plugin");
            this.initCallbackService = null;
            this.savedResult = null;
            cordovaPlugin.onActivityResult(n2, n3, intent);
            return true;
        }
        LOG.w(TAG, "Got an activity result, but no plugin was registered to receive it" + (this.savedResult != null ? " yet!" : "."));
        return false;
    }

    public void setActivityResultRequestCode(int n2) {
        this.activityResultRequestCode = n2;
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (this.activityResultCallback != null) {
            String string2 = this.activityResultCallback.getServiceName();
            bundle.putString("callbackService", string2);
        }
        if (this.pluginManager != null) {
            bundle.putBundle("plugin", this.pluginManager.onSaveInstanceState());
        }
    }

    public void restoreInstanceState(Bundle bundle) {
        this.initCallbackService = bundle.getString("callbackService");
        this.savedPluginState = bundle.getBundle("plugin");
        this.activityWasDestroyed = true;
    }

    public void onRequestPermissionResult(int n2, String[] stringArray, int[] nArray) {
        Pair<CordovaPlugin, Integer> pair = this.permissionResultCallbacks.getAndRemoveCallback(n2);
        if (pair != null) {
            ((CordovaPlugin)pair.first).onRequestPermissionResult((Integer)pair.second, stringArray, nArray);
        }
    }

    @Override
    public void requestPermission(CordovaPlugin cordovaPlugin, int n2, String string2) {
        String[] stringArray = new String[]{string2};
        this.requestPermissions(cordovaPlugin, n2, stringArray);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void requestPermissions(CordovaPlugin cordovaPlugin, int n2, String[] stringArray) {
        int n3 = this.permissionResultCallbacks.registerCallback(cordovaPlugin, n2);
        this.getActivity().requestPermissions(stringArray, n3);
    }

    @Override
    public boolean hasPermission(String string2) {
        if (Build.VERSION.SDK_INT >= 23) {
            int n2 = this.activity.checkSelfPermission(string2);
            return 0 == n2;
        }
        return true;
    }

    private static class ActivityResultHolder {
        private int requestCode;
        private int resultCode;
        private Intent intent;

        public ActivityResultHolder(int n2, int n3, Intent intent) {
            this.requestCode = n2;
            this.resultCode = n3;
            this.intent = intent;
        }
    }
}

