/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Looper;
import android.util.Base64;
import android.webkit.MimeTypeMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Locale;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginManager;

public class CordovaResourceApi {
    private static final String LOG_TAG = "CordovaResourceApi";
    public static final int URI_TYPE_FILE = 0;
    public static final int URI_TYPE_ASSET = 1;
    public static final int URI_TYPE_CONTENT = 2;
    public static final int URI_TYPE_RESOURCE = 3;
    public static final int URI_TYPE_DATA = 4;
    public static final int URI_TYPE_HTTP = 5;
    public static final int URI_TYPE_HTTPS = 6;
    public static final int URI_TYPE_PLUGIN = 7;
    public static final int URI_TYPE_UNKNOWN = -1;
    public static final String PLUGIN_URI_SCHEME = "cdvplugin";
    private static final String[] LOCAL_FILE_PROJECTION = new String[]{"_data"};
    public static Thread jsThread;
    private final AssetManager assetManager;
    private final ContentResolver contentResolver;
    private final PluginManager pluginManager;
    private boolean threadCheckingEnabled = true;

    public CordovaResourceApi(Context context, PluginManager pluginManager) {
        this.contentResolver = context.getContentResolver();
        this.assetManager = context.getAssets();
        this.pluginManager = pluginManager;
    }

    public void setThreadCheckingEnabled(boolean bl) {
        this.threadCheckingEnabled = bl;
    }

    public boolean isThreadCheckingEnabled() {
        return this.threadCheckingEnabled;
    }

    public static int getUriType(Uri uri) {
        CordovaResourceApi.assertNonRelative(uri);
        String string2 = uri.getScheme();
        if ("content".equalsIgnoreCase(string2)) {
            return 2;
        }
        if ("android.resource".equalsIgnoreCase(string2)) {
            return 3;
        }
        if ("file".equalsIgnoreCase(string2)) {
            if (uri.getPath().startsWith("/android_asset/")) {
                return 1;
            }
            return 0;
        }
        if ("data".equalsIgnoreCase(string2)) {
            return 4;
        }
        if ("http".equalsIgnoreCase(string2)) {
            return 5;
        }
        if ("https".equalsIgnoreCase(string2)) {
            return 6;
        }
        if (PLUGIN_URI_SCHEME.equalsIgnoreCase(string2)) {
            return 7;
        }
        return -1;
    }

    public Uri remapUri(Uri uri) {
        CordovaResourceApi.assertNonRelative(uri);
        Uri uri2 = this.pluginManager.remapUri(uri);
        return uri2 != null ? uri2 : uri;
    }

    public String remapPath(String string2) {
        return this.remapUri(Uri.fromFile((File)new File(string2))).getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File mapUriToFile(Uri uri) {
        this.assertBackgroundThread();
        switch (CordovaResourceApi.getUriType(uri)) {
            case 0: {
                return new File(uri.getPath());
            }
            case 2: {
                Cursor cursor = this.contentResolver.query(uri, LOCAL_FILE_PROJECTION, null, null, null);
                if (cursor == null) break;
                try {
                    int n2 = cursor.getColumnIndex(LOCAL_FILE_PROJECTION[0]);
                    if (n2 != -1 && cursor.getCount() > 0) {
                        cursor.moveToFirst();
                        String string2 = cursor.getString(n2);
                        if (string2 != null) {
                            File file = new File(string2);
                            return file;
                        }
                    }
                    break;
                }
                finally {
                    cursor.close();
                }
            }
        }
        return null;
    }

    public String getMimeType(Uri uri) {
        switch (CordovaResourceApi.getUriType(uri)) {
            case 0: 
            case 1: {
                return this.getMimeTypeFromPath(uri.getPath());
            }
            case 2: 
            case 3: {
                return this.contentResolver.getType(uri);
            }
            case 4: {
                return this.getDataUriMimeType(uri);
            }
            case 5: 
            case 6: {
                try {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(uri.toString()).openConnection();
                    httpURLConnection.setDoInput(false);
                    httpURLConnection.setRequestMethod("HEAD");
                    String string2 = httpURLConnection.getHeaderField("Content-Type");
                    if (string2 != null) {
                        string2 = string2.split(";")[0];
                    }
                    return string2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private String getMimeTypeFromPath(String string2) {
        String string3 = string2;
        int n2 = string3.lastIndexOf(46);
        if (n2 != -1) {
            string3 = string3.substring(n2 + 1);
        }
        if ((string3 = string3.toLowerCase(Locale.getDefault())).equals("3ga")) {
            return "audio/3gpp";
        }
        if (string3.equals("js")) {
            return "text/javascript";
        }
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
    }

    public OpenForReadResult openForRead(Uri uri) {
        return this.openForRead(uri, false);
    }

    public OpenForReadResult openForRead(Uri uri, boolean bl) {
        if (!bl) {
            this.assertBackgroundThread();
        }
        switch (CordovaResourceApi.getUriType(uri)) {
            case 0: {
                FileInputStream fileInputStream = new FileInputStream(uri.getPath());
                String string2 = this.getMimeTypeFromPath(uri.getPath());
                long l2 = fileInputStream.getChannel().size();
                return new OpenForReadResult(uri, fileInputStream, string2, l2, null);
            }
            case 1: {
                InputStream inputStream;
                String string3 = uri.getPath().substring(15);
                AssetFileDescriptor assetFileDescriptor = null;
                long l3 = -1L;
                try {
                    assetFileDescriptor = this.assetManager.openFd(string3);
                    inputStream = assetFileDescriptor.createInputStream();
                    l3 = assetFileDescriptor.getLength();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    inputStream = this.assetManager.open(string3);
                    l3 = inputStream.available();
                }
                String string4 = this.getMimeTypeFromPath(string3);
                return new OpenForReadResult(uri, inputStream, string4, l3, assetFileDescriptor);
            }
            case 2: 
            case 3: {
                String string5 = this.contentResolver.getType(uri);
                AssetFileDescriptor assetFileDescriptor = this.contentResolver.openAssetFileDescriptor(uri, "r");
                FileInputStream fileInputStream = assetFileDescriptor.createInputStream();
                long l4 = assetFileDescriptor.getLength();
                return new OpenForReadResult(uri, fileInputStream, string5, l4, assetFileDescriptor);
            }
            case 4: {
                OpenForReadResult openForReadResult = this.readDataUri(uri);
                if (openForReadResult == null) break;
                return openForReadResult;
            }
            case 5: 
            case 6: {
                HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(uri.toString()).openConnection();
                httpURLConnection.setDoInput(true);
                String string6 = httpURLConnection.getHeaderField("Content-Type");
                if (string6 != null) {
                    string6 = string6.split(";")[0];
                }
                int n2 = httpURLConnection.getContentLength();
                InputStream inputStream = httpURLConnection.getInputStream();
                return new OpenForReadResult(uri, inputStream, string6, n2, null);
            }
            case 7: {
                String string7 = uri.getHost();
                CordovaPlugin cordovaPlugin = this.pluginManager.getPlugin(string7);
                if (cordovaPlugin == null) {
                    throw new FileNotFoundException("Invalid plugin ID in URI: " + uri);
                }
                return cordovaPlugin.handleOpenForRead(uri);
            }
        }
        throw new FileNotFoundException("URI not supported by CordovaResourceApi: " + uri);
    }

    public OutputStream openOutputStream(Uri uri) {
        return this.openOutputStream(uri, false);
    }

    public OutputStream openOutputStream(Uri uri, boolean bl) {
        this.assertBackgroundThread();
        switch (CordovaResourceApi.getUriType(uri)) {
            case 0: {
                File file = new File(uri.getPath());
                File file2 = file.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                return new FileOutputStream(file, bl);
            }
            case 2: 
            case 3: {
                AssetFileDescriptor assetFileDescriptor = this.contentResolver.openAssetFileDescriptor(uri, bl ? "wa" : "w");
                return assetFileDescriptor.createOutputStream();
            }
        }
        throw new FileNotFoundException("URI not supported by CordovaResourceApi: " + uri);
    }

    public HttpURLConnection createHttpConnection(Uri uri) {
        this.assertBackgroundThread();
        return (HttpURLConnection)new URL(uri.toString()).openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(OpenForReadResult openForReadResult, OutputStream outputStream) {
        block8: {
            this.assertBackgroundThread();
            try {
                int n2;
                InputStream inputStream = openForReadResult.inputStream;
                if (inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                    FileChannel fileChannel = ((FileInputStream)openForReadResult.inputStream).getChannel();
                    FileChannel fileChannel2 = ((FileOutputStream)outputStream).getChannel();
                    long l2 = 0L;
                    long l3 = openForReadResult.length;
                    if (openForReadResult.assetFd != null) {
                        l2 = openForReadResult.assetFd.getStartOffset();
                    }
                    fileChannel.position(l2);
                    fileChannel2.transferFrom(fileChannel, 0L, l3);
                    break block8;
                }
                int n3 = 8192;
                byte[] byArray = new byte[8192];
                while ((n2 = inputStream.read(byArray, 0, 8192)) > 0) {
                    outputStream.write(byArray, 0, n2);
                }
            }
            finally {
                openForReadResult.inputStream.close();
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    public void copyResource(Uri uri, OutputStream outputStream) {
        this.copyResource(this.openForRead(uri), outputStream);
    }

    public void copyResource(Uri uri, Uri uri2) {
        this.copyResource(this.openForRead(uri), this.openOutputStream(uri2));
    }

    private void assertBackgroundThread() {
        if (this.threadCheckingEnabled) {
            Thread thread = Thread.currentThread();
            if (thread == Looper.getMainLooper().getThread()) {
                throw new IllegalStateException("Do not perform IO operations on the UI thread. Use CordovaInterface.getThreadPool() instead.");
            }
            if (thread == jsThread) {
                throw new IllegalStateException("Tried to perform an IO operation on the WebCore thread. Use CordovaInterface.getThreadPool() instead.");
            }
        }
    }

    private String getDataUriMimeType(Uri uri) {
        String string2 = uri.getSchemeSpecificPart();
        int n2 = string2.indexOf(44);
        if (n2 == -1) {
            return null;
        }
        String[] stringArray = string2.substring(0, n2).split(";");
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    private OpenForReadResult readDataUri(Uri uri) {
        byte[] byArray;
        String string2 = uri.getSchemeSpecificPart();
        int n2 = string2.indexOf(44);
        if (n2 == -1) {
            return null;
        }
        String[] stringArray = string2.substring(0, n2).split(";");
        String string3 = null;
        boolean bl = false;
        if (stringArray.length > 0) {
            string3 = stringArray[0];
        }
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            if (!"base64".equalsIgnoreCase(stringArray[i2])) continue;
            bl = true;
        }
        String string4 = string2.substring(n2 + 1);
        if (bl) {
            byArray = Base64.decode((String)string4, (int)0);
        } else {
            try {
                byArray = string4.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string4.getBytes();
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new OpenForReadResult(uri, byteArrayInputStream, string3, byArray.length, null);
    }

    private static void assertNonRelative(Uri uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Relative URIs are not supported.");
        }
    }

    public static final class OpenForReadResult {
        public final Uri uri;
        public final InputStream inputStream;
        public final String mimeType;
        public final long length;
        public final AssetFileDescriptor assetFd;

        public OpenForReadResult(Uri uri, InputStream inputStream, String string2, long l2, AssetFileDescriptor assetFileDescriptor) {
            this.uri = uri;
            this.inputStream = inputStream;
            this.mimeType = string2;
            this.length = l2;
            this.assetFd = assetFileDescriptor;
        }
    }
}

