/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.TelephonyManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CoreAndroid
extends CordovaPlugin {
    public static final String PLUGIN_NAME = "CoreAndroid";
    protected static final String TAG = "CordovaApp";
    private BroadcastReceiver telephonyReceiver;
    private CallbackContext messageChannel;
    private PluginResult pendingResume;
    private PluginResult pendingPause;
    private final Object messageChannelLock = new Object();

    public void fireJavascriptEvent(String string2) {
        this.sendEventMessage(string2);
    }

    @Override
    public void pluginInitialize() {
        this.initTelephonyReceiver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string2, JSONArray jSONArray, CallbackContext callbackContext) {
        PluginResult.Status status = PluginResult.Status.OK;
        String string3 = "";
        try {
            if (string2.equals("clearCache")) {
                this.clearCache();
            } else if (string2.equals("show")) {
                this.cordova.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CoreAndroid.this.webView.getPluginManager().postMessage("spinner", "stop");
                    }
                });
            } else if (string2.equals("loadUrl")) {
                this.loadUrl(jSONArray.getString(0), jSONArray.optJSONObject(1));
            } else if (!string2.equals("cancelLoadUrl")) {
                if (string2.equals("clearHistory")) {
                    this.clearHistory();
                } else if (string2.equals("backHistory")) {
                    this.backHistory();
                } else if (string2.equals("overrideButton")) {
                    this.overrideButton(jSONArray.getString(0), jSONArray.getBoolean(1));
                } else if (string2.equals("overrideBackbutton")) {
                    this.overrideBackbutton(jSONArray.getBoolean(0));
                } else if (string2.equals("exitApp")) {
                    this.exitApp();
                } else if (string2.equals("messageChannel")) {
                    Object object = this.messageChannelLock;
                    synchronized (object) {
                        this.messageChannel = callbackContext;
                        if (this.pendingPause != null) {
                            this.sendEventMessage(this.pendingPause);
                            this.pendingPause = null;
                        }
                        if (this.pendingResume != null) {
                            this.sendEventMessage(this.pendingResume);
                            this.pendingResume = null;
                        }
                    }
                    return true;
                }
            }
            callbackContext.sendPluginResult(new PluginResult(status, string3));
            return true;
        }
        catch (JSONException jSONException) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
            return false;
        }
    }

    public void clearCache() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CoreAndroid.this.webView.clearCache();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUrl(String string2, JSONObject jSONObject) {
        Object object;
        LOG.d("App", "App.loadUrl(" + string2 + "," + jSONObject + ")");
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (jSONObject != null) {
            object = jSONObject.names();
            for (int i2 = 0; i2 < object.length(); ++i2) {
                String string3 = object.getString(i2);
                if (string3.equals("wait")) {
                    n2 = jSONObject.getInt(string3);
                    continue;
                }
                if (string3.equalsIgnoreCase("openexternal")) {
                    bl = jSONObject.getBoolean(string3);
                    continue;
                }
                if (string3.equalsIgnoreCase("clearhistory")) {
                    bl2 = jSONObject.getBoolean(string3);
                    continue;
                }
                Object object2 = jSONObject.get(string3);
                if (object2 == null) continue;
                if (object2.getClass().equals(String.class)) {
                    hashMap.put(string3, (String)object2);
                    continue;
                }
                if (object2.getClass().equals(Boolean.class)) {
                    hashMap.put(string3, (Boolean)object2);
                    continue;
                }
                if (!object2.getClass().equals(Integer.class)) continue;
                hashMap.put(string3, (Integer)object2);
            }
        }
        if (n2 > 0) {
            try {
                object = this;
                synchronized (object) {
                    this.wait(n2);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.webView.showWebPage(string2, bl, bl2, hashMap);
    }

    public void clearHistory() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CoreAndroid.this.webView.clearHistory();
            }
        });
    }

    public void backHistory() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CoreAndroid.this.webView.backHistory();
            }
        });
    }

    public void overrideBackbutton(boolean bl) {
        LOG.i("App", "WARNING: Back Button Default Behavior will be overridden.  The backbutton event will be fired!");
        this.webView.setButtonPlumbedToJs(4, bl);
    }

    public void overrideButton(String string2, boolean bl) {
        LOG.i("App", "WARNING: Volume Button Default Behavior will be overridden.  The volume event will be fired!");
        if (string2.equals("volumeup")) {
            this.webView.setButtonPlumbedToJs(24, bl);
        } else if (string2.equals("volumedown")) {
            this.webView.setButtonPlumbedToJs(25, bl);
        } else if (string2.equals("menubutton")) {
            this.webView.setButtonPlumbedToJs(82, bl);
        }
    }

    public boolean isBackbuttonOverridden() {
        return this.webView.isButtonPlumbedToJs(4);
    }

    public void exitApp() {
        this.webView.getPluginManager().postMessage("exit", null);
    }

    private void initTelephonyReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PHONE_STATE");
        this.telephonyReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null && intent.getAction().equals("android.intent.action.PHONE_STATE") && intent.hasExtra("state")) {
                    String string2 = intent.getStringExtra("state");
                    if (string2.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                        LOG.i(CoreAndroid.TAG, "Telephone RINGING");
                        CoreAndroid.this.webView.getPluginManager().postMessage("telephone", "ringing");
                    } else if (string2.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                        LOG.i(CoreAndroid.TAG, "Telephone OFFHOOK");
                        CoreAndroid.this.webView.getPluginManager().postMessage("telephone", "offhook");
                    } else if (string2.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                        LOG.i(CoreAndroid.TAG, "Telephone IDLE");
                        CoreAndroid.this.webView.getPluginManager().postMessage("telephone", "idle");
                    }
                }
            }
        };
        this.webView.getContext().registerReceiver(this.telephonyReceiver, intentFilter);
    }

    private void sendEventMessage(String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("action", (Object)string2);
        }
        catch (JSONException jSONException) {
            LOG.e(TAG, "Failed to create event message", jSONException);
        }
        PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, jSONObject);
        if (this.messageChannel == null) {
            LOG.i(TAG, "Request to send event before messageChannel initialised: " + string2);
            if ("pause".equals(string2)) {
                this.pendingPause = pluginResult;
            } else if ("resume".equals(string2)) {
                this.pendingPause = null;
            }
        } else {
            this.sendEventMessage(pluginResult);
        }
    }

    private void sendEventMessage(PluginResult pluginResult) {
        pluginResult.setKeepCallback(true);
        if (this.messageChannel != null) {
            this.messageChannel.sendPluginResult(pluginResult);
        }
    }

    @Override
    public void onDestroy() {
        this.webView.getContext().unregisterReceiver(this.telephonyReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResumeEvent(PluginResult pluginResult) {
        Object object = this.messageChannelLock;
        synchronized (object) {
            if (this.messageChannel != null) {
                this.sendEventMessage(pluginResult);
            } else {
                this.pendingResume = pluginResult;
            }
        }
    }

    public static Object getBuildConfigValue(Context context, String string2) {
        try {
            Class<?> clazz = Class.forName(context.getPackageName() + ".BuildConfig");
            Field field = clazz.getField(string2);
            return field.get(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.d(TAG, "Unable to get the BuildConfig, is this built with ANT?");
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOG.d(TAG, string2 + " is not a valid field. Check your build.gradle");
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.d(TAG, "Illegal Access Exception: Let's print a stack trace.");
            illegalAccessException.printStackTrace();
        }
        return null;
    }
}

