/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.util.Base64;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class PluginResult {
    private final int status;
    private final int messageType;
    private boolean keepCallback = false;
    private String strMessage;
    private String encodedMessage;
    private List<PluginResult> multipartMessages;
    public static final int MESSAGE_TYPE_STRING = 1;
    public static final int MESSAGE_TYPE_JSON = 2;
    public static final int MESSAGE_TYPE_NUMBER = 3;
    public static final int MESSAGE_TYPE_BOOLEAN = 4;
    public static final int MESSAGE_TYPE_NULL = 5;
    public static final int MESSAGE_TYPE_ARRAYBUFFER = 6;
    public static final int MESSAGE_TYPE_BINARYSTRING = 7;
    public static final int MESSAGE_TYPE_MULTIPART = 8;
    public static String[] StatusMessages = new String[]{"No result", "OK", "Class not found", "Illegal access", "Instantiation error", "Malformed url", "IO error", "Invalid action", "JSON error", "Error"};

    public PluginResult(Status status) {
        this(status, StatusMessages[status.ordinal()]);
    }

    public PluginResult(Status status, String string2) {
        this.status = status.ordinal();
        this.messageType = string2 == null ? 5 : 1;
        this.strMessage = string2;
    }

    public PluginResult(Status status, JSONArray jSONArray) {
        this.status = status.ordinal();
        this.messageType = 2;
        this.encodedMessage = jSONArray.toString();
    }

    public PluginResult(Status status, JSONObject jSONObject) {
        this.status = status.ordinal();
        this.messageType = 2;
        this.encodedMessage = jSONObject.toString();
    }

    public PluginResult(Status status, int n2) {
        this.status = status.ordinal();
        this.messageType = 3;
        this.encodedMessage = "" + n2;
    }

    public PluginResult(Status status, float f2) {
        this.status = status.ordinal();
        this.messageType = 3;
        this.encodedMessage = "" + f2;
    }

    public PluginResult(Status status, boolean bl) {
        this.status = status.ordinal();
        this.messageType = 4;
        this.encodedMessage = Boolean.toString(bl);
    }

    public PluginResult(Status status, byte[] byArray) {
        this(status, byArray, false);
    }

    public PluginResult(Status status, byte[] byArray, boolean bl) {
        this.status = status.ordinal();
        this.messageType = bl ? 7 : 6;
        this.encodedMessage = Base64.encodeToString((byte[])byArray, (int)2);
    }

    public PluginResult(Status status, List<PluginResult> list) {
        this.status = status.ordinal();
        this.messageType = 8;
        this.multipartMessages = list;
    }

    public void setKeepCallback(boolean bl) {
        this.keepCallback = bl;
    }

    public int getStatus() {
        return this.status;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public String getMessage() {
        if (this.encodedMessage == null) {
            this.encodedMessage = JSONObject.quote((String)this.strMessage);
        }
        return this.encodedMessage;
    }

    public int getMultipartMessagesSize() {
        return this.multipartMessages.size();
    }

    public PluginResult getMultipartMessage(int n2) {
        return this.multipartMessages.get(n2);
    }

    public String getStrMessage() {
        return this.strMessage;
    }

    public boolean getKeepCallback() {
        return this.keepCallback;
    }

    @Deprecated
    public String getJSONString() {
        return "{\"status\":" + this.status + ",\"message\":" + this.getMessage() + ",\"keepCallback\":" + this.keepCallback + "}";
    }

    @Deprecated
    public String toCallbackString(String string2) {
        if (this.status == Status.NO_RESULT.ordinal() && this.keepCallback) {
            return null;
        }
        if (this.status == Status.OK.ordinal() || this.status == Status.NO_RESULT.ordinal()) {
            return this.toSuccessCallbackString(string2);
        }
        return this.toErrorCallbackString(string2);
    }

    @Deprecated
    public String toSuccessCallbackString(String string2) {
        return "cordova.callbackSuccess('" + string2 + "'," + this.getJSONString() + ");";
    }

    @Deprecated
    public String toErrorCallbackString(String string2) {
        return "cordova.callbackError('" + string2 + "', " + this.getJSONString() + ");";
    }

    public static enum Status {
        NO_RESULT,
        OK,
        CLASS_NOT_FOUND_EXCEPTION,
        ILLEGAL_ACCESS_EXCEPTION,
        INSTANTIATION_EXCEPTION,
        MALFORMED_URL_EXCEPTION,
        IO_EXCEPTION,
        INVALID_ACTION,
        JSON_EXCEPTION,
        ERROR;

    }
}

