/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.net.Uri;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cordova.LOG;

public class Whitelist {
    private ArrayList<URLPattern> whiteList = new ArrayList();
    public static final String TAG = "Whitelist";

    public void addWhiteListEntry(String string2, boolean bl) {
        if (this.whiteList != null) {
            try {
                if (string2.compareTo("*") == 0) {
                    LOG.d(TAG, "Unlimited access to network resources");
                    this.whiteList = null;
                } else {
                    Pattern pattern = Pattern.compile("^((\\*|[A-Za-z-]+):(//)?)?(\\*|((\\*\\.)?[^*/:]+))?(:(\\d+))?(/.*)?");
                    Matcher matcher = pattern.matcher(string2);
                    if (matcher.matches()) {
                        String string3 = matcher.group(2);
                        String string4 = matcher.group(4);
                        if (("file".equals(string3) || "content".equals(string3)) && string4 == null) {
                            string4 = "*";
                        }
                        String string5 = matcher.group(8);
                        String string6 = matcher.group(9);
                        if (string3 == null) {
                            this.whiteList.add(new URLPattern("http", string4, string5, string6));
                            this.whiteList.add(new URLPattern("https", string4, string5, string6));
                        } else {
                            this.whiteList.add(new URLPattern(string3, string4, string5, string6));
                        }
                    }
                }
            }
            catch (Exception exception) {
                LOG.d(TAG, "Failed to add origin %s", string2);
            }
        }
    }

    public boolean isUrlWhiteListed(String string2) {
        if (this.whiteList == null) {
            return true;
        }
        Uri uri = Uri.parse((String)string2);
        for (URLPattern uRLPattern : this.whiteList) {
            if (!uRLPattern.matches(uri)) continue;
            return true;
        }
        return false;
    }

    private static class URLPattern {
        public Pattern scheme;
        public Pattern host;
        public Integer port;
        public Pattern path;

        private String regexFromPattern(String string2, boolean bl) {
            String string3 = "\\.[]{}()^$?+|";
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                if (c2 == '*' && bl) {
                    stringBuilder.append(".");
                } else if ("\\.[]{}()^$?+|".indexOf(c2) > -1) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }

        public URLPattern(String string2, String string3, String string4, String string5) {
            try {
                this.scheme = string2 == null || "*".equals(string2) ? null : Pattern.compile(this.regexFromPattern(string2, false), 2);
                this.host = "*".equals(string3) ? null : (string3.startsWith("*.") ? Pattern.compile("([a-z0-9.-]*\\.)?" + this.regexFromPattern(string3.substring(2), false), 2) : Pattern.compile(this.regexFromPattern(string3, false), 2));
                this.port = string4 == null || "*".equals(string4) ? null : Integer.valueOf(Integer.parseInt(string4, 10));
                this.path = string5 == null || "/*".equals(string5) ? null : Pattern.compile(this.regexFromPattern(string5, true));
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException("Port must be a number");
            }
        }

        public boolean matches(Uri uri) {
            try {
                return !(this.scheme != null && !this.scheme.matcher(uri.getScheme()).matches() || this.host != null && !this.host.matcher(uri.getHost()).matches() || this.port != null && !this.port.equals(uri.getPort()) || this.path != null && !this.path.matcher(uri.getPath()).matches());
            }
            catch (Exception exception) {
                LOG.d(Whitelist.TAG, exception.toString());
                return false;
            }
        }
    }
}

