/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.camera;

import android.content.ActivityNotFoundException;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.a.b;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.cordova.BuildHelper;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.PermissionHelper;
import org.apache.cordova.PluginResult;
import org.apache.cordova.camera.CordovaUri;
import org.apache.cordova.camera.ExifHelper;
import org.apache.cordova.camera.FileHelper;
import org.json.JSONArray;

public class CameraLauncher
extends CordovaPlugin
implements MediaScannerConnection.MediaScannerConnectionClient {
    private static final int DATA_URL = 0;
    private static final int FILE_URI = 1;
    private static final int NATIVE_URI = 2;
    private static final int PHOTOLIBRARY = 0;
    private static final int CAMERA = 1;
    private static final int SAVEDPHOTOALBUM = 2;
    private static final int PICTURE = 0;
    private static final int VIDEO = 1;
    private static final int ALLMEDIA = 2;
    private static final int JPEG = 0;
    private static final int PNG = 1;
    private static final String JPEG_TYPE = "jpg";
    private static final String PNG_TYPE = "png";
    private static final String JPEG_EXTENSION = ".jpg";
    private static final String PNG_EXTENSION = ".png";
    private static final String PNG_MIME_TYPE = "image/png";
    private static final String JPEG_MIME_TYPE = "image/jpeg";
    private static final String GET_PICTURE = "Get Picture";
    private static final String GET_VIDEO = "Get Video";
    private static final String GET_All = "Get All";
    private static final String CROPPED_URI_KEY = "croppedUri";
    private static final String IMAGE_URI_KEY = "imageUri";
    private static final String TAKE_PICTURE_ACTION = "takePicture";
    public static final int PERMISSION_DENIED_ERROR = 20;
    public static final int TAKE_PIC_SEC = 0;
    public static final int SAVE_TO_ALBUM_SEC = 1;
    private static final String LOG_TAG = "LukeLauncher";
    private static final int CROP_CAMERA = 100;
    private static final String TIME_FORMAT = "yyyyMMdd_HHmmss";
    private int mQuality;
    private int targetWidth;
    private int targetHeight;
    private CordovaUri imageUri;
    private int encodingType;
    private int mediaType;
    private int destType;
    private int srcType;
    private boolean saveToPhotoAlbum;
    private boolean correctOrientation;
    private boolean orientationCorrected;
    private boolean allowEdit;
    protected static final String[] permissions = new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public CallbackContext callbackContext;
    private int numPics;
    private MediaScannerConnection conn;
    private Uri scanMe;
    private Uri croppedUri;
    private ExifHelper exifData;
    private String applicationId;

    @Override
    public boolean execute(String string2, JSONArray jSONArray, CallbackContext callbackContext) {
        this.callbackContext = callbackContext;
        this.applicationId = (String)BuildHelper.getBuildConfigValue((Context)this.cordova.getActivity(), "APPLICATION_ID");
        this.applicationId = this.preferences.getString("applicationId", this.applicationId);
        if (string2.equals(TAKE_PICTURE_ACTION)) {
            this.srcType = 1;
            this.destType = 1;
            this.saveToPhotoAlbum = false;
            this.targetHeight = 0;
            this.targetWidth = 0;
            this.encodingType = 0;
            this.mediaType = 0;
            this.mQuality = 50;
            this.destType = jSONArray.getInt(1);
            this.srcType = jSONArray.getInt(2);
            this.mQuality = jSONArray.getInt(0);
            this.targetWidth = jSONArray.getInt(3);
            this.targetHeight = jSONArray.getInt(4);
            this.encodingType = jSONArray.getInt(5);
            this.mediaType = jSONArray.getInt(6);
            this.allowEdit = jSONArray.getBoolean(7);
            this.correctOrientation = jSONArray.getBoolean(8);
            this.saveToPhotoAlbum = jSONArray.getBoolean(9);
            if (this.targetWidth < 1) {
                this.targetWidth = -1;
            }
            if (this.targetHeight < 1) {
                this.targetHeight = -1;
            }
            if (this.targetHeight == -1 && this.targetWidth == -1 && this.mQuality == 100 && !this.correctOrientation && this.encodingType == 1 && this.srcType == 1) {
                this.encodingType = 0;
            }
            try {
                if (this.srcType == 1) {
                    this.callTakePicture(this.destType, this.encodingType);
                } else if (this.srcType == 0 || this.srcType == 2) {
                    if (!PermissionHelper.hasPermission(this, "android.permission.READ_EXTERNAL_STORAGE")) {
                        PermissionHelper.requestPermission(this, 1, "android.permission.READ_EXTERNAL_STORAGE");
                    } else {
                        this.getImage(this.srcType, this.destType, this.encodingType);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                callbackContext.error("Illegal Argument Exception");
                PluginResult pluginResult = new PluginResult(PluginResult.Status.ERROR);
                callbackContext.sendPluginResult(pluginResult);
                return true;
            }
            PluginResult pluginResult = new PluginResult(PluginResult.Status.NO_RESULT);
            pluginResult.setKeepCallback(true);
            callbackContext.sendPluginResult(pluginResult);
            return true;
        }
        return false;
    }

    private String getTempDirectoryPath() {
        File file = null;
        file = Environment.getExternalStorageState().equals("mounted") ? this.cordova.getActivity().getExternalCacheDir() : this.cordova.getActivity().getCacheDir();
        file.mkdirs();
        return file.getAbsolutePath();
    }

    public void callTakePicture(int n2, int n3) {
        boolean bl;
        boolean bl2;
        block10: {
            bl2 = PermissionHelper.hasPermission(this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionHelper.hasPermission(this, "android.permission.WRITE_EXTERNAL_STORAGE");
            bl = PermissionHelper.hasPermission(this, "android.permission.CAMERA");
            if (!bl) {
                bl = true;
                try {
                    PackageManager packageManager = this.cordova.getActivity().getPackageManager();
                    String[] stringArray = packageManager.getPackageInfo((String)this.cordova.getActivity().getPackageName(), (int)4096).requestedPermissions;
                    if (stringArray == null) break block10;
                    for (String string2 : stringArray) {
                        if (!string2.equals("android.permission.CAMERA")) continue;
                        bl = false;
                        break;
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (bl && bl2) {
            this.takePicture(n2, n3);
        } else if (bl2 && !bl) {
            PermissionHelper.requestPermission(this, 0, "android.permission.CAMERA");
        } else if (!bl2 && bl) {
            PermissionHelper.requestPermissions(this, 0, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        } else {
            PermissionHelper.requestPermissions(this, 0, permissions);
        }
    }

    public void takePicture(int n2, int n3) {
        this.numPics = this.queryImgDB(this.whichContentStore()).getCount();
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File file = this.createCaptureFile(n3);
        this.imageUri = new CordovaUri(b.getUriForFile((Context)this.cordova.getActivity(), this.applicationId + ".provider", file));
        intent.putExtra("output", (Parcelable)this.imageUri.getCorrectUri());
        intent.addFlags(2);
        if (this.cordova != null) {
            PackageManager packageManager = this.cordova.getActivity().getPackageManager();
            if (intent.resolveActivity(packageManager) != null) {
                this.cordova.startActivityForResult(this, intent, 32 + n2 + 1);
            } else {
                LOG.d(LOG_TAG, "Error: You don't have a default camera.  Your device may not be CTS complaint.");
            }
        }
    }

    private File createCaptureFile(int n2) {
        return this.createCaptureFile(n2, "");
    }

    private File createCaptureFile(int n2, String string2) {
        if (string2.isEmpty()) {
            string2 = ".Pic";
        }
        if (n2 == 0) {
            string2 = string2 + JPEG_EXTENSION;
        } else if (n2 == 1) {
            string2 = string2 + PNG_EXTENSION;
        } else {
            throw new IllegalArgumentException("Invalid Encoding Type: " + n2);
        }
        return new File(this.getTempDirectoryPath(), string2);
    }

    public void getImage(int n2, int n3, int n4) {
        Intent intent = new Intent();
        String string2 = GET_PICTURE;
        this.croppedUri = null;
        if (this.mediaType == 0) {
            intent.setType("image/*");
            if (this.allowEdit) {
                intent.setAction("android.intent.action.PICK");
                intent.putExtra("crop", "true");
                if (this.targetWidth > 0) {
                    intent.putExtra("outputX", this.targetWidth);
                }
                if (this.targetHeight > 0) {
                    intent.putExtra("outputY", this.targetHeight);
                }
                if (this.targetHeight > 0 && this.targetWidth > 0 && this.targetWidth == this.targetHeight) {
                    intent.putExtra("aspectX", 1);
                    intent.putExtra("aspectY", 1);
                }
                File file = this.createCaptureFile(0);
                this.croppedUri = Uri.fromFile((File)file);
                intent.putExtra("output", (Parcelable)this.croppedUri);
            } else {
                intent.setAction("android.intent.action.GET_CONTENT");
                intent.addCategory("android.intent.category.OPENABLE");
            }
        } else if (this.mediaType == 1) {
            intent.setType("video/*");
            string2 = GET_VIDEO;
            intent.setAction("android.intent.action.GET_CONTENT");
            intent.addCategory("android.intent.category.OPENABLE");
        } else if (this.mediaType == 2) {
            intent.setType("*/*");
            string2 = GET_All;
            intent.setAction("android.intent.action.GET_CONTENT");
            intent.addCategory("android.intent.category.OPENABLE");
        }
        if (this.cordova != null) {
            this.cordova.startActivityForResult(this, Intent.createChooser((Intent)intent, (CharSequence)new String(string2)), (n2 + 1) * 16 + n3 + 1);
        }
    }

    private void performCrop(Uri uri, int n2, Intent intent) {
        try {
            Intent intent2 = new Intent("com.android.camera.action.CROP");
            intent2.setDataAndType(uri, "image/*");
            intent2.putExtra("crop", "true");
            if (this.targetWidth > 0) {
                intent2.putExtra("outputX", this.targetWidth);
            }
            if (this.targetHeight > 0) {
                intent2.putExtra("outputY", this.targetHeight);
            }
            if (this.targetHeight > 0 && this.targetWidth > 0 && this.targetWidth == this.targetHeight) {
                intent2.putExtra("aspectX", 1);
                intent2.putExtra("aspectY", 1);
            }
            this.croppedUri = Uri.fromFile((File)this.createCaptureFile(this.encodingType, System.currentTimeMillis() + ""));
            intent2.addFlags(1);
            intent2.addFlags(2);
            intent2.putExtra("output", (Parcelable)this.croppedUri);
            if (this.cordova != null) {
                this.cordova.startActivityForResult(this, intent2, 100 + n2);
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            LOG.e(LOG_TAG, "Crop operation not supported on this device");
            try {
                this.processResultFromCamera(n2, intent);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                LOG.e(LOG_TAG, "Unable to write to file");
            }
        }
    }

    private void processResultFromCamera(int n2, Intent intent) {
        Uri uri;
        String string2;
        int n3 = 0;
        ExifHelper exifHelper = new ExifHelper();
        String string3 = string2 = this.allowEdit && this.croppedUri != null ? FileHelper.stripFileProtocol(this.croppedUri.toString()) : this.imageUri.getFilePath();
        if (this.encodingType == 0) {
            try {
                exifHelper.createInFile(string2);
                exifHelper.readExifData();
                n3 = exifHelper.getOrientation();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        Bitmap bitmap = null;
        Uri uri2 = null;
        if (this.saveToPhotoAlbum) {
            uri2 = Uri.fromFile((File)new File(this.getPicturesPath()));
            if (this.allowEdit && this.croppedUri != null) {
                this.writeUncompressedImage(this.croppedUri, uri2);
            } else {
                uri = this.imageUri.getFileUri();
                this.writeUncompressedImage(uri, uri2);
            }
            this.refreshGallery(uri2);
        }
        if (n2 == 0) {
            bitmap = this.getScaledAndRotatedBitmap(string2);
            if (bitmap == null) {
                bitmap = (Bitmap)intent.getExtras().get("data");
            }
            if (bitmap == null) {
                LOG.d(LOG_TAG, "I either have a null image path or bitmap");
                this.failPicture("Unable to create bitmap!");
                return;
            }
            this.processPicture(bitmap, this.encodingType);
            if (!this.saveToPhotoAlbum) {
                this.checkForDuplicateImage(0);
            }
        } else if (n2 == 1 || n2 == 2) {
            if (this.targetHeight == -1 && this.targetWidth == -1 && this.mQuality == 100 && !this.correctOrientation) {
                if (this.saveToPhotoAlbum) {
                    this.callbackContext.success(uri2.toString());
                } else {
                    uri = Uri.fromFile((File)this.createCaptureFile(this.encodingType, System.currentTimeMillis() + ""));
                    if (this.allowEdit && this.croppedUri != null) {
                        Uri uri3 = Uri.fromFile((File)new File(this.getFileNameFromUri(this.croppedUri)));
                        this.writeUncompressedImage(uri3, uri);
                    } else {
                        Uri uri4 = this.imageUri.getFileUri();
                        this.writeUncompressedImage(uri4, uri);
                    }
                    this.callbackContext.success(uri.toString());
                }
            } else {
                uri = Uri.fromFile((File)this.createCaptureFile(this.encodingType, System.currentTimeMillis() + ""));
                bitmap = this.getScaledAndRotatedBitmap(string2);
                if (bitmap == null) {
                    LOG.d(LOG_TAG, "I either have a null image path or bitmap");
                    this.failPicture("Unable to create bitmap!");
                    return;
                }
                OutputStream outputStream = this.cordova.getActivity().getContentResolver().openOutputStream(uri);
                Bitmap.CompressFormat compressFormat = this.encodingType == 0 ? Bitmap.CompressFormat.JPEG : Bitmap.CompressFormat.PNG;
                bitmap.compress(compressFormat, this.mQuality, outputStream);
                outputStream.close();
                if (this.encodingType == 0) {
                    String string4 = uri.getPath();
                    if (n3 != 1) {
                        exifHelper.resetOrientation();
                    }
                    exifHelper.createOutFile(string4);
                    exifHelper.writeExifData();
                }
                this.callbackContext.success(uri.toString());
            }
        } else {
            throw new IllegalStateException();
        }
        this.cleanup(1, this.imageUri.getFileUri(), uri2, bitmap);
        bitmap = null;
    }

    private String getPicturesPath() {
        String string2 = new SimpleDateFormat(TIME_FORMAT).format(new Date());
        String string3 = "IMG_" + string2 + (this.encodingType == 0 ? JPEG_EXTENSION : PNG_EXTENSION);
        File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        file.mkdirs();
        String string4 = file.getAbsolutePath() + "/" + string3;
        return string4;
    }

    private void refreshGallery(Uri uri) {
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        intent.setData(uri);
        this.cordova.getActivity().sendBroadcast(intent);
    }

    private String getMimetypeForFormat(int n2) {
        if (n2 == 1) {
            return PNG_MIME_TYPE;
        }
        if (n2 == 0) {
            return JPEG_MIME_TYPE;
        }
        return "";
    }

    private String outputModifiedBitmap(Bitmap bitmap, Uri uri) {
        String string2 = FileHelper.getRealPath(uri, this.cordova);
        String string3 = string2 != null ? string2.substring(string2.lastIndexOf(47) + 1) : "modified." + (this.encodingType == 0 ? JPEG_TYPE : PNG_TYPE);
        String string4 = new SimpleDateFormat(TIME_FORMAT).format(new Date());
        String string5 = this.getTempDirectoryPath() + "/" + string3;
        FileOutputStream fileOutputStream = new FileOutputStream(string5);
        Bitmap.CompressFormat compressFormat = this.encodingType == 0 ? Bitmap.CompressFormat.JPEG : Bitmap.CompressFormat.PNG;
        bitmap.compress(compressFormat, this.mQuality, (OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        if (this.exifData != null && this.encodingType == 0) {
            try {
                if (this.correctOrientation && this.orientationCorrected) {
                    this.exifData.resetOrientation();
                }
                this.exifData.createOutFile(string5);
                this.exifData.writeExifData();
                this.exifData = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string5;
    }

    private void processResultFromGallery(int n2, Intent intent) {
        Uri uri = intent.getData();
        if (uri == null) {
            if (this.croppedUri != null) {
                uri = this.croppedUri;
            } else {
                this.failPicture("null data from photo library");
                return;
            }
        }
        boolean bl = false;
        String string2 = FileHelper.getRealPath(uri, this.cordova);
        String string3 = uri.toString();
        String string4 = FileHelper.getMimeType(string3, this.cordova);
        if (this.mediaType == 1 || !JPEG_MIME_TYPE.equalsIgnoreCase(string4) && !PNG_MIME_TYPE.equalsIgnoreCase(string4)) {
            this.callbackContext.success(string2);
        } else if (this.targetHeight == -1 && this.targetWidth == -1 && (n2 == 1 || n2 == 2) && !this.correctOrientation && string4 != null && string4.equalsIgnoreCase(this.getMimetypeForFormat(this.encodingType))) {
            this.callbackContext.success(string3);
        } else {
            Bitmap bitmap = null;
            try {
                bitmap = this.getScaledAndRotatedBitmap(string3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bitmap == null) {
                LOG.d(LOG_TAG, "I either have a null image path or bitmap");
                this.failPicture("Unable to create bitmap!");
                return;
            }
            if (n2 == 0) {
                this.processPicture(bitmap, this.encodingType);
            } else if (n2 == 1 || n2 == 2) {
                if (this.targetHeight > 0 && this.targetWidth > 0 || this.correctOrientation && this.orientationCorrected || !string4.equalsIgnoreCase(this.getMimetypeForFormat(this.encodingType))) {
                    try {
                        String string5 = this.outputModifiedBitmap(bitmap, uri);
                        this.callbackContext.success("file://" + string5 + "?" + System.currentTimeMillis());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.failPicture("Error retrieving image.");
                    }
                } else {
                    this.callbackContext.success(string2);
                }
            }
            if (bitmap != null) {
                bitmap.recycle();
                bitmap = null;
            }
            System.gc();
        }
    }

    @Override
    public void onActivityResult(int n2, int n3, Intent intent) {
        block22: {
            int n4 = n2 / 16 - 1;
            int n5 = n2 % 16 - 1;
            if (n2 >= 100) {
                if (n3 == -1) {
                    n5 = n2 - 100;
                    try {
                        this.processResultFromCamera(n5, intent);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        LOG.e(LOG_TAG, "Unable to write to file");
                    }
                } else if (n3 == 0) {
                    this.failPicture("No Image Selected");
                } else {
                    this.failPicture("Did not complete!");
                }
            } else if (n4 == 1) {
                if (n3 == -1) {
                    try {
                        if (this.allowEdit) {
                            Uri uri = b.getUriForFile((Context)this.cordova.getActivity(), this.applicationId + ".provider", this.createCaptureFile(this.encodingType));
                            this.performCrop(uri, n5, intent);
                            break block22;
                        }
                        this.processResultFromCamera(n5, intent);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this.failPicture("Error capturing image.");
                    }
                } else if (n3 == 0) {
                    this.failPicture("No Image Selected");
                } else {
                    this.failPicture("Did not complete!");
                }
            } else if (n4 == 0 || n4 == 2) {
                if (n3 == -1 && intent != null) {
                    final Intent intent2 = intent;
                    final int n6 = n5;
                    this.cordova.getThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            CameraLauncher.this.processResultFromGallery(n6, intent2);
                        }
                    });
                } else if (n3 == 0) {
                    this.failPicture("No Image Selected");
                } else {
                    this.failPicture("Selection did not complete!");
                }
            }
        }
    }

    private int exifToDegrees(int n2) {
        if (n2 == 6) {
            return 90;
        }
        if (n2 == 3) {
            return 180;
        }
        if (n2 == 8) {
            return 270;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUncompressedImage(InputStream inputStream, Uri uri) {
        OutputStream outputStream = null;
        try {
            int n2;
            outputStream = this.cordova.getActivity().getContentResolver().openOutputStream(uri);
            byte[] byArray = new byte[4096];
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
            outputStream.flush();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    LOG.d(LOG_TAG, "Exception while closing output stream.");
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LOG.d(LOG_TAG, "Exception while closing file input stream.");
                }
            }
        }
    }

    private void writeUncompressedImage(Uri uri, Uri uri2) {
        FileInputStream fileInputStream = new FileInputStream(FileHelper.stripFileProtocol(uri.toString()));
        this.writeUncompressedImage(fileInputStream, uri2);
    }

    private Uri getUriFromMediaStore() {
        Uri uri;
        ContentValues contentValues = new ContentValues();
        contentValues.put("mime_type", JPEG_MIME_TYPE);
        try {
            uri = this.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
        }
        catch (RuntimeException runtimeException) {
            LOG.d(LOG_TAG, "Can't write to external media storage.");
            try {
                uri = this.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, contentValues);
            }
            catch (RuntimeException runtimeException2) {
                LOG.d(LOG_TAG, "Can't write to internal media storage.");
                return null;
            }
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap getScaledAndRotatedBitmap(String string2) {
        Object object;
        String string3;
        Object object2;
        InputStream inputStream;
        int n2;
        Uri uri;
        File file;
        block55: {
            if (this.targetWidth <= 0 && this.targetHeight <= 0 && !this.correctOrientation) {
                InputStream inputStream2 = null;
                Bitmap bitmap = null;
                try {
                    inputStream2 = FileHelper.getInputStreamFromUriString(string2, this.cordova);
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.callbackContext.error(outOfMemoryError.getLocalizedMessage());
                }
                catch (Exception exception) {
                    this.callbackContext.error(exception.getLocalizedMessage());
                }
                finally {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException) {
                            LOG.d(LOG_TAG, "Exception while closing file input stream.");
                        }
                    }
                }
                return bitmap;
            }
            file = null;
            uri = null;
            n2 = 0;
            try {
                inputStream = FileHelper.getInputStreamFromUriString(string2, this.cordova);
                if (inputStream == null) break block55;
                object2 = new SimpleDateFormat(TIME_FORMAT).format(new Date());
                string3 = "IMG_" + (String)object2 + (this.encodingType == 0 ? JPEG_EXTENSION : PNG_EXTENSION);
                file = new File(this.getTempDirectoryPath() + string3);
                uri = Uri.fromFile((File)file);
                this.writeUncompressedImage(inputStream, uri);
                try {
                    String string4 = FileHelper.getMimeType(string2.toString(), this.cordova);
                    if (JPEG_MIME_TYPE.equalsIgnoreCase(string4)) {
                        String string5 = uri.toString().replace("file://", "");
                        this.exifData = new ExifHelper();
                        this.exifData.createInFile(string5);
                        this.exifData.readExifData();
                        if (this.correctOrientation) {
                            object = new ExifInterface(string5);
                            n2 = this.exifToDegrees(object.getAttributeInt("Orientation", 0));
                        }
                    }
                }
                catch (Exception exception) {
                    LOG.w(LOG_TAG, "Unable to read Exif data: " + exception.toString());
                    n2 = 0;
                }
            }
            catch (Exception exception) {
                LOG.e(LOG_TAG, "Exception while getting input stream: " + exception.toString());
                return null;
            }
        }
        try {
            Bitmap bitmap;
            int n3;
            int n4;
            int n5;
            inputStream = new BitmapFactory.Options();
            ((BitmapFactory.Options)inputStream).inJustDecodeBounds = true;
            object2 = null;
            try {
                object2 = FileHelper.getInputStreamFromUriString(uri.toString(), this.cordova);
                BitmapFactory.decodeStream((InputStream)object2, null, (BitmapFactory.Options)inputStream);
            }
            finally {
                if (object2 != null) {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        LOG.d(LOG_TAG, "Exception while closing file input stream.");
                    }
                }
            }
            if (((BitmapFactory.Options)inputStream).outWidth == 0 || ((BitmapFactory.Options)inputStream).outHeight == 0) {
                string3 = null;
                return string3;
            }
            if (this.targetWidth <= 0 && this.targetHeight <= 0) {
                this.targetWidth = ((BitmapFactory.Options)inputStream).outWidth;
                this.targetHeight = ((BitmapFactory.Options)inputStream).outHeight;
            }
            boolean bl = false;
            if (n2 == 90 || n2 == 270) {
                n5 = ((BitmapFactory.Options)inputStream).outHeight;
                n4 = ((BitmapFactory.Options)inputStream).outWidth;
                bl = true;
            } else {
                n5 = ((BitmapFactory.Options)inputStream).outWidth;
                n4 = ((BitmapFactory.Options)inputStream).outHeight;
            }
            object = this.calculateAspectRatio(n5, n4);
            ((BitmapFactory.Options)inputStream).inJustDecodeBounds = false;
            ((BitmapFactory.Options)inputStream).inSampleSize = CameraLauncher.calculateSampleSize(n5, n4, object[0], object[1]);
            Bitmap bitmap2 = null;
            try {
                object2 = FileHelper.getInputStreamFromUriString(uri.toString(), this.cordova);
                bitmap2 = BitmapFactory.decodeStream((InputStream)object2, null, (BitmapFactory.Options)inputStream);
            }
            finally {
                if (object2 != null) {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        LOG.d(LOG_TAG, "Exception while closing file input stream.");
                    }
                }
            }
            if (bitmap2 == null) {
                Bitmap bitmap3 = null;
                return bitmap3;
            }
            int n6 = !bl ? object[0] : object[1];
            Bitmap bitmap4 = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)n6, (int)(n3 = !bl ? object[1] : object[0]), (boolean)true);
            if (bitmap4 != bitmap2) {
                bitmap2.recycle();
                bitmap2 = null;
            }
            if (this.correctOrientation && n2 != 0) {
                bitmap = new Matrix();
                bitmap.setRotate((float)n2);
                try {
                    bitmap4 = Bitmap.createBitmap((Bitmap)bitmap4, (int)0, (int)0, (int)bitmap4.getWidth(), (int)bitmap4.getHeight(), (Matrix)bitmap, (boolean)true);
                    this.orientationCorrected = true;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.orientationCorrected = false;
                }
            }
            bitmap = bitmap4;
            return bitmap;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public int[] calculateAspectRatio(int n2, int n3) {
        int n4 = this.targetWidth;
        int n5 = this.targetHeight;
        if (n4 <= 0 && n5 <= 0) {
            n4 = n2;
            n5 = n3;
        } else if (n4 > 0 && n5 <= 0) {
            n5 = (int)((double)n4 / (double)n2 * (double)n3);
        } else if (n4 <= 0 && n5 > 0) {
            n4 = (int)((double)n5 / (double)n3 * (double)n2);
        } else {
            double d2 = (double)n2 / (double)n3;
            double d3 = (double)n4 / (double)n5;
            if (d2 > d3) {
                n5 = n4 * n3 / n2;
            } else if (d2 < d3) {
                n4 = n5 * n2 / n3;
            }
        }
        int[] nArray = new int[]{n4, n5};
        return nArray;
    }

    public static int calculateSampleSize(int n2, int n3, int n4, int n5) {
        float f2 = (float)n2 / (float)n3;
        float f3 = (float)n4 / (float)n5;
        if (f2 > f3) {
            return n2 / n4;
        }
        return n3 / n5;
    }

    private Cursor queryImgDB(Uri uri) {
        return this.cordova.getActivity().getContentResolver().query(uri, new String[]{"_id"}, null, null, null);
    }

    private void cleanup(int n2, Uri uri, Uri uri2, Bitmap bitmap) {
        if (bitmap != null) {
            bitmap.recycle();
        }
        new File(FileHelper.stripFileProtocol(uri.toString())).delete();
        this.checkForDuplicateImage(n2);
        if (this.saveToPhotoAlbum && uri2 != null) {
            this.scanForGallery(uri2);
        }
        System.gc();
    }

    private void checkForDuplicateImage(int n2) {
        int n3 = 1;
        Uri uri = this.whichContentStore();
        Cursor cursor = this.queryImgDB(uri);
        int n4 = cursor.getCount();
        if (n2 == 1 && this.saveToPhotoAlbum) {
            n3 = 2;
        }
        if (n4 - this.numPics == n3) {
            cursor.moveToLast();
            int n5 = Integer.valueOf(cursor.getString(cursor.getColumnIndex("_id")));
            if (n3 == 2) {
                --n5;
            }
            Uri uri2 = Uri.parse((String)(uri + "/" + n5));
            this.cordova.getActivity().getContentResolver().delete(uri2, null, null);
            cursor.close();
        }
    }

    private Uri whichContentStore() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        }
        return MediaStore.Images.Media.INTERNAL_CONTENT_URI;
    }

    public void processPicture(Bitmap bitmap, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Bitmap.CompressFormat compressFormat = n2 == 0 ? Bitmap.CompressFormat.JPEG : Bitmap.CompressFormat.PNG;
        try {
            if (bitmap.compress(compressFormat, this.mQuality, (OutputStream)byteArrayOutputStream)) {
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = Base64.encode((byte[])byArray, (int)2);
                String string2 = new String(byArray2);
                this.callbackContext.success(string2);
                string2 = null;
                byArray2 = null;
                byArray = null;
            }
        }
        catch (Exception exception) {
            this.failPicture("Error compressing image.");
        }
        byteArrayOutputStream = null;
    }

    public void failPicture(String string2) {
        this.callbackContext.error(string2);
    }

    private void scanForGallery(Uri uri) {
        this.scanMe = uri;
        if (this.conn != null) {
            this.conn.disconnect();
        }
        this.conn = new MediaScannerConnection(this.cordova.getActivity().getApplicationContext(), (MediaScannerConnection.MediaScannerConnectionClient)this);
        this.conn.connect();
    }

    public void onMediaScannerConnected() {
        try {
            this.conn.scanFile(this.scanMe.toString(), "image/*");
        }
        catch (IllegalStateException illegalStateException) {
            LOG.e(LOG_TAG, "Can't scan file in MediaScanner after taking picture");
        }
    }

    public void onScanCompleted(String string2, Uri uri) {
        this.conn.disconnect();
    }

    @Override
    public void onRequestPermissionResult(int n2, String[] stringArray, int[] nArray) {
        for (int n3 : nArray) {
            if (n3 != -1) continue;
            this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, 20));
            return;
        }
        switch (n2) {
            case 0: {
                this.takePicture(this.destType, this.encodingType);
                break;
            }
            case 1: {
                this.getImage(this.srcType, this.destType, this.encodingType);
            }
        }
    }

    @Override
    public Bundle onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putInt("destType", this.destType);
        bundle.putInt("srcType", this.srcType);
        bundle.putInt("mQuality", this.mQuality);
        bundle.putInt("targetWidth", this.targetWidth);
        bundle.putInt("targetHeight", this.targetHeight);
        bundle.putInt("encodingType", this.encodingType);
        bundle.putInt("mediaType", this.mediaType);
        bundle.putInt("numPics", this.numPics);
        bundle.putBoolean("allowEdit", this.allowEdit);
        bundle.putBoolean("correctOrientation", this.correctOrientation);
        bundle.putBoolean("saveToPhotoAlbum", this.saveToPhotoAlbum);
        if (this.croppedUri != null) {
            bundle.putString(CROPPED_URI_KEY, this.croppedUri.toString());
        }
        if (this.imageUri != null) {
            bundle.putString(IMAGE_URI_KEY, this.imageUri.getFileUri().toString());
        }
        return bundle;
    }

    @Override
    public void onRestoreStateForActivityResult(Bundle bundle, CallbackContext callbackContext) {
        this.destType = bundle.getInt("destType");
        this.srcType = bundle.getInt("srcType");
        this.mQuality = bundle.getInt("mQuality");
        this.targetWidth = bundle.getInt("targetWidth");
        this.targetHeight = bundle.getInt("targetHeight");
        this.encodingType = bundle.getInt("encodingType");
        this.mediaType = bundle.getInt("mediaType");
        this.numPics = bundle.getInt("numPics");
        this.allowEdit = bundle.getBoolean("allowEdit");
        this.correctOrientation = bundle.getBoolean("correctOrientation");
        this.saveToPhotoAlbum = bundle.getBoolean("saveToPhotoAlbum");
        if (bundle.containsKey(CROPPED_URI_KEY)) {
            this.croppedUri = Uri.parse((String)bundle.getString(CROPPED_URI_KEY));
        }
        if (bundle.containsKey(IMAGE_URI_KEY)) {
            this.imageUri = new CordovaUri(Uri.parse((String)bundle.getString(IMAGE_URI_KEY)));
        }
        this.callbackContext = callbackContext;
    }

    private String getFileNameFromUri(Uri uri) {
        String string2 = uri.toString();
        String string3 = string2.split("external_files")[1];
        File file = Environment.getExternalStorageDirectory();
        String string4 = file.getAbsolutePath() + string3;
        return string4;
    }
}

