/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.camera;

import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import org.apache.cordova.camera.FileHelper;

public class CordovaUri {
    private Uri androidUri;
    private String fileName;
    private Uri fileUri;

    CordovaUri(Uri uri) {
        if (uri.getScheme().equals("content")) {
            this.androidUri = uri;
            this.fileName = this.getFileNameFromUri(this.androidUri);
            this.fileUri = Uri.parse((String)("file://" + this.fileName));
        } else {
            this.fileUri = uri;
            this.fileName = FileHelper.stripFileProtocol(uri.toString());
        }
    }

    public Uri getFileUri() {
        return this.fileUri;
    }

    public String getFilePath() {
        return this.fileName;
    }

    public Uri getCorrectUri() {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.androidUri;
        }
        return this.fileUri;
    }

    private String getFileNameFromUri(Uri uri) {
        String string2 = uri.toString();
        String string3 = string2.split("external_files")[1];
        File file = Environment.getExternalStorageDirectory();
        String string4 = file.getAbsolutePath() + string3;
        return string4;
    }
}

