/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.device;

import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import java.util.TimeZone;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.json.JSONArray;
import org.json.JSONObject;

public class Device
extends CordovaPlugin {
    public static final String TAG = "Device";
    public static String platform;
    public static String uuid;
    private static final String ANDROID_PLATFORM = "Android";
    private static final String AMAZON_PLATFORM = "amazon-fireos";
    private static final String AMAZON_DEVICE = "Amazon";

    @Override
    public void initialize(CordovaInterface cordovaInterface, CordovaWebView cordovaWebView) {
        super.initialize(cordovaInterface, cordovaWebView);
        uuid = this.getUuid();
    }

    @Override
    public boolean execute(String string2, JSONArray jSONArray, CallbackContext callbackContext) {
        if (!"getDeviceInfo".equals(string2)) {
            return false;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("uuid", (Object)uuid);
        jSONObject.put("version", (Object)this.getOSVersion());
        jSONObject.put("platform", (Object)this.getPlatform());
        jSONObject.put("model", (Object)this.getModel());
        jSONObject.put("manufacturer", (Object)this.getManufacturer());
        jSONObject.put("isVirtual", this.isVirtual());
        jSONObject.put("serial", (Object)this.getSerialNumber());
        callbackContext.success(jSONObject);
        return true;
    }

    public String getPlatform() {
        String string2 = this.isAmazonDevice() ? AMAZON_PLATFORM : ANDROID_PLATFORM;
        return string2;
    }

    public String getUuid() {
        String string2 = Settings.Secure.getString((ContentResolver)this.cordova.getActivity().getContentResolver(), (String)"android_id");
        return string2;
    }

    public String getModel() {
        String string2 = Build.MODEL;
        return string2;
    }

    public String getProductName() {
        String string2 = Build.PRODUCT;
        return string2;
    }

    public String getManufacturer() {
        String string2 = Build.MANUFACTURER;
        return string2;
    }

    public String getSerialNumber() {
        String string2 = Build.SERIAL;
        return string2;
    }

    public String getOSVersion() {
        String string2 = Build.VERSION.RELEASE;
        return string2;
    }

    public String getSDKVersion() {
        String string2 = Build.VERSION.SDK;
        return string2;
    }

    public String getTimeZoneID() {
        TimeZone timeZone = TimeZone.getDefault();
        return timeZone.getID();
    }

    public boolean isAmazonDevice() {
        return Build.MANUFACTURER.equals(AMAZON_DEVICE);
    }

    public boolean isVirtual() {
        return Build.FINGERPRINT.contains("generic") || Build.PRODUCT.contains("sdk");
    }
}

