/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.annotation.TargetApi;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.WebView;
import org.apache.cordova.ICordovaCookieManager;

class SystemCookieManager
implements ICordovaCookieManager {
    protected final WebView webView;
    private final CookieManager cookieManager;

    @TargetApi(value=21)
    public SystemCookieManager(WebView webView) {
        this.webView = webView;
        this.cookieManager = CookieManager.getInstance();
        CookieManager.setAcceptFileSchemeCookies((boolean)true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.setAcceptThirdPartyCookies(this.webView, true);
        }
    }

    @Override
    public void setCookiesEnabled(boolean bl) {
        this.cookieManager.setAcceptCookie(bl);
    }

    @Override
    public void setCookie(String string2, String string3) {
        this.cookieManager.setCookie(string2, string3);
    }

    @Override
    public String getCookie(String string2) {
        return this.cookieManager.getCookie(string2);
    }

    @Override
    public void clearCookies() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.removeAllCookies(null);
        } else {
            this.cookieManager.removeAllCookie();
        }
    }

    @Override
    public void flush() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        }
    }
}

