/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.cordova.CordovaDialogsHelper;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.engine.SystemWebViewEngine;

public class SystemWebChromeClient
extends WebChromeClient {
    private static final int FILECHOOSER_RESULTCODE = 5173;
    private static final String LOG_TAG = "SystemWebChromeClient";
    private long MAX_QUOTA = 0x6400000L;
    protected final SystemWebViewEngine parentEngine;
    private View mVideoProgressView;
    private CordovaDialogsHelper dialogsHelper;
    private Context appContext;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private View mCustomView;

    public SystemWebChromeClient(SystemWebViewEngine systemWebViewEngine) {
        this.parentEngine = systemWebViewEngine;
        this.appContext = systemWebViewEngine.webView.getContext();
        this.dialogsHelper = new CordovaDialogsHelper(this.appContext);
    }

    public boolean onJsAlert(WebView webView, String string2, String string3, final JsResult jsResult) {
        this.dialogsHelper.showAlert(string3, new CordovaDialogsHelper.Result(){

            @Override
            public void gotResult(boolean bl, String string2) {
                if (bl) {
                    jsResult.confirm();
                } else {
                    jsResult.cancel();
                }
            }
        });
        return true;
    }

    public boolean onJsConfirm(WebView webView, String string2, String string3, final JsResult jsResult) {
        this.dialogsHelper.showConfirm(string3, new CordovaDialogsHelper.Result(){

            @Override
            public void gotResult(boolean bl, String string2) {
                if (bl) {
                    jsResult.confirm();
                } else {
                    jsResult.cancel();
                }
            }
        });
        return true;
    }

    public boolean onJsPrompt(WebView webView, String string2, String string3, String string4, final JsPromptResult jsPromptResult) {
        String string5 = this.parentEngine.bridge.promptOnJsPrompt(string2, string3, string4);
        if (string5 != null) {
            jsPromptResult.confirm(string5);
        } else {
            this.dialogsHelper.showPrompt(string3, string4, new CordovaDialogsHelper.Result(){

                @Override
                public void gotResult(boolean bl, String string2) {
                    if (bl) {
                        jsPromptResult.confirm(string2);
                    } else {
                        jsPromptResult.cancel();
                    }
                }
            });
        }
        return true;
    }

    public void onExceededDatabaseQuota(String string2, String string3, long l2, long l3, long l4, WebStorage.QuotaUpdater quotaUpdater) {
        LOG.d(LOG_TAG, "onExceededDatabaseQuota estimatedSize: %d  currentQuota: %d  totalUsedQuota: %d", l3, l2, l4);
        quotaUpdater.updateQuota(this.MAX_QUOTA);
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (consoleMessage.message() != null) {
            LOG.d(LOG_TAG, "%s: Line %d : %s", consoleMessage.sourceId(), consoleMessage.lineNumber(), consoleMessage.message());
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public void onGeolocationPermissionsShowPrompt(String string2, GeolocationPermissions.Callback callback) {
        super.onGeolocationPermissionsShowPrompt(string2, callback);
        callback.invoke(string2, true, false);
        CordovaPlugin cordovaPlugin = this.parentEngine.pluginManager.getPlugin("Geolocation");
        if (cordovaPlugin != null && !cordovaPlugin.hasPermisssion()) {
            cordovaPlugin.requestPermissions(0);
        }
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.parentEngine.getCordovaWebView().showCustomView(view, customViewCallback);
    }

    public void onHideCustomView() {
        this.parentEngine.getCordovaWebView().hideCustomView();
    }

    public View getVideoLoadingProgressView() {
        if (this.mVideoProgressView == null) {
            LinearLayout linearLayout = new LinearLayout(this.parentEngine.getView().getContext());
            linearLayout.setOrientation(1);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ProgressBar progressBar = new ProgressBar(this.parentEngine.getView().getContext());
            LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
            layoutParams2.gravity = 17;
            progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            linearLayout.addView((View)progressBar);
            this.mVideoProgressView = linearLayout;
        }
        return this.mVideoProgressView;
    }

    public void openFileChooser(ValueCallback<Uri> valueCallback) {
        this.openFileChooser(valueCallback, "*/*");
    }

    public void openFileChooser(ValueCallback<Uri> valueCallback, String string2) {
        this.openFileChooser(valueCallback, string2, null);
    }

    public void openFileChooser(final ValueCallback<Uri> valueCallback, String string2, String string3) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("*/*");
        this.parentEngine.cordova.startActivityForResult(new CordovaPlugin(){

            @Override
            public void onActivityResult(int n2, int n3, Intent intent) {
                Uri uri = intent == null || n3 != -1 ? null : intent.getData();
                LOG.d(SystemWebChromeClient.LOG_TAG, "Receive file chooser URL: " + uri);
                valueCallback.onReceiveValue((Object)uri);
            }
        }, intent, 5173);
    }

    @TargetApi(value=21)
    public boolean onShowFileChooser(WebView webView, final ValueCallback<Uri[]> valueCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        Boolean bl = false;
        if (fileChooserParams.getMode() == 1) {
            bl = true;
        }
        Intent intent = fileChooserParams.createIntent();
        intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", (Serializable)bl);
        try {
            this.parentEngine.cordova.startActivityForResult(new CordovaPlugin(){

                @Override
                public void onActivityResult(int n2, int n3, Intent intent) {
                    Uri[] uriArray = null;
                    if (n3 == -1 && intent != null) {
                        if (intent.getClipData() != null) {
                            int n4 = intent.getClipData().getItemCount();
                            uriArray = new Uri[n4];
                            for (int i2 = 0; i2 < n4; ++i2) {
                                uriArray[i2] = intent.getClipData().getItemAt(i2).getUri();
                                LOG.d(SystemWebChromeClient.LOG_TAG, "Receive file chooser URL: " + uriArray[i2]);
                            }
                        } else if (intent.getData() != null) {
                            uriArray = WebChromeClient.FileChooserParams.parseResult((int)n3, (Intent)intent);
                            LOG.d(SystemWebChromeClient.LOG_TAG, "Receive file chooser URL: " + uriArray);
                        }
                    }
                    valueCallback.onReceiveValue(uriArray);
                }
            }, intent, 5173);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            LOG.w("No activity found to handle file chooser intent.", activityNotFoundException);
            valueCallback.onReceiveValue(null);
        }
        return true;
    }

    @TargetApi(value=21)
    public void onPermissionRequest(PermissionRequest permissionRequest) {
        LOG.d(LOG_TAG, "onPermissionRequest: " + Arrays.toString(permissionRequest.getResources()));
        permissionRequest.grant(permissionRequest.getResources());
    }

    public void destroyLastDialog() {
        this.dialogsHelper.destroyLastDialog();
    }
}

