/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.whitelist;

import android.content.Context;
import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.Whitelist;
import org.xmlpull.v1.XmlPullParser;

public class WhitelistPlugin
extends CordovaPlugin {
    private Whitelist allowedNavigations;
    private Whitelist allowedIntents;
    private Whitelist allowedRequests;

    public WhitelistPlugin() {
    }

    public WhitelistPlugin(Context context) {
        this(new Whitelist(), new Whitelist(), null);
        new CustomConfigXmlParser().parse(context);
    }

    public WhitelistPlugin(XmlPullParser xmlPullParser) {
        this(new Whitelist(), new Whitelist(), null);
        new CustomConfigXmlParser().parse(xmlPullParser);
    }

    public WhitelistPlugin(Whitelist whitelist, Whitelist whitelist2, Whitelist whitelist3) {
        if (whitelist3 == null) {
            whitelist3 = new Whitelist();
            whitelist3.addWhiteListEntry("file:///*", false);
            whitelist3.addWhiteListEntry("data:*", false);
        }
        this.allowedNavigations = whitelist;
        this.allowedIntents = whitelist2;
        this.allowedRequests = whitelist3;
    }

    @Override
    public void pluginInitialize() {
        if (this.allowedNavigations == null) {
            this.allowedNavigations = new Whitelist();
            this.allowedIntents = new Whitelist();
            this.allowedRequests = new Whitelist();
            new CustomConfigXmlParser().parse(this.webView.getContext());
        }
    }

    @Override
    public Boolean shouldAllowNavigation(String string2) {
        if (this.allowedNavigations.isUrlWhiteListed(string2)) {
            return true;
        }
        return null;
    }

    @Override
    public Boolean shouldAllowRequest(String string2) {
        if (Boolean.TRUE == this.shouldAllowNavigation(string2)) {
            return true;
        }
        if (this.allowedRequests.isUrlWhiteListed(string2)) {
            return true;
        }
        return null;
    }

    @Override
    public Boolean shouldOpenExternalUrl(String string2) {
        if (this.allowedIntents.isUrlWhiteListed(string2)) {
            return true;
        }
        return null;
    }

    public Whitelist getAllowedNavigations() {
        return this.allowedNavigations;
    }

    public void setAllowedNavigations(Whitelist whitelist) {
        this.allowedNavigations = whitelist;
    }

    public Whitelist getAllowedIntents() {
        return this.allowedIntents;
    }

    public void setAllowedIntents(Whitelist whitelist) {
        this.allowedIntents = whitelist;
    }

    public Whitelist getAllowedRequests() {
        return this.allowedRequests;
    }

    public void setAllowedRequests(Whitelist whitelist) {
        this.allowedRequests = whitelist;
    }

    private class CustomConfigXmlParser
    extends ConfigXmlParser {
        private CustomConfigXmlParser() {
        }

        @Override
        public void handleStartTag(XmlPullParser xmlPullParser) {
            String string2 = xmlPullParser.getName();
            if (string2.equals("content")) {
                String string3 = xmlPullParser.getAttributeValue(null, "src");
                WhitelistPlugin.this.allowedNavigations.addWhiteListEntry(string3, false);
            } else if (string2.equals("allow-navigation")) {
                String string4 = xmlPullParser.getAttributeValue(null, "href");
                if ("*".equals(string4)) {
                    WhitelistPlugin.this.allowedNavigations.addWhiteListEntry("http://*/*", false);
                    WhitelistPlugin.this.allowedNavigations.addWhiteListEntry("https://*/*", false);
                    WhitelistPlugin.this.allowedNavigations.addWhiteListEntry("data:*", false);
                } else {
                    WhitelistPlugin.this.allowedNavigations.addWhiteListEntry(string4, false);
                }
            } else if (string2.equals("allow-intent")) {
                String string5 = xmlPullParser.getAttributeValue(null, "href");
                WhitelistPlugin.this.allowedIntents.addWhiteListEntry(string5, false);
            } else if (string2.equals("access")) {
                boolean bl;
                String string6 = xmlPullParser.getAttributeValue(null, "origin");
                String string7 = xmlPullParser.getAttributeValue(null, "subdomains");
                boolean bl2 = bl = xmlPullParser.getAttributeValue(null, "launch-external") != null;
                if (string6 != null) {
                    if (bl) {
                        WhitelistPlugin.this.allowedIntents.addWhiteListEntry(string6, string7 != null && string7.compareToIgnoreCase("true") == 0);
                    } else if ("*".equals(string6)) {
                        WhitelistPlugin.this.allowedRequests.addWhiteListEntry("http://*/*", false);
                        WhitelistPlugin.this.allowedRequests.addWhiteListEntry("https://*/*", false);
                    } else {
                        WhitelistPlugin.this.allowedRequests.addWhiteListEntry(string6, string7 != null && string7.compareToIgnoreCase("true") == 0);
                    }
                }
            }
        }

        @Override
        public void handleEndTag(XmlPullParser xmlPullParser) {
        }
    }
}

