/*
 * Decompiled with CFR 0.152.
 */
package com.darryncampbell.cordova.plugin.intent;

import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.LauncherApps;
import android.content.pm.ShortcutInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.v4.a.a;
import android.support.v4.a.b;
import android.text.Html;
import android.util.Log;
import android.view.KeyEvent;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IntentShim
extends CordovaPlugin {
    private CallbackContext a = null;
    private CallbackContext b = null;
    private CallbackContext c = null;
    private Intent d = null;
    private BroadcastReceiver e = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if (IntentShim.this.b != null) {
                try {
                    Object object;
                    Bitmap bitmap;
                    String string3 = "blank";
                    String string4 = "blank";
                    String string5 = "default";
                    String string6 = "blank";
                    String string7 = "";
                    try {
                        string3 = intent.getStringExtra("android.intent.extra.shortcut.NAME");
                    }
                    catch (Exception exception) {
                        string3 = "blank";
                    }
                    try {
                        bitmap = (Bitmap)intent.getParcelableExtra("android.intent.extra.shortcut.ICON");
                        bitmap = IntentShim.this.a(bitmap, 512, 512);
                        string7 = "/data/data/luke.launcher/appicons/";
                        string6 = "" + System.currentTimeMillis() + ".png";
                        object = new File(string7, string6);
                        FileOutputStream fileOutputStream = null;
                        fileOutputStream = new FileOutputStream((File)object);
                        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
                        fileOutputStream.flush();
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (Exception exception) {
                        string6 = "blank";
                    }
                    bitmap = null;
                    try {
                        object = (Intent)intent.getParcelableExtra("android.intent.extra.shortcut.INTENT");
                        bitmap = IntentShim.this.d((Intent)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        string4 = bitmap.getString("data");
                    }
                    catch (Exception exception) {
                        string4 = "blank";
                    }
                    try {
                        string5 = bitmap.getString("component");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        string5 = bitmap.getString("package");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object = new PluginResult(PluginResult.Status.OK, string5 + "|,|" + string3 + "|,|" + string4 + "|,|" + string7 + string6);
                    ((PluginResult)object).setKeepCallback(true);
                    IntentShim.this.b.sendPluginResult((PluginResult)object);
                }
                catch (Exception exception) {
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, "default|,|blank|,|blank|,|blank");
                    pluginResult.setKeepCallback(true);
                    IntentShim.this.b.sendPluginResult(pluginResult);
                }
            }
        }
    };

    public static Bitmap a(Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap = null;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmapDrawable = new Canvas(bitmap);
        drawable2.setBounds(0, 0, bitmapDrawable.getWidth(), bitmapDrawable.getHeight());
        drawable2.draw((Canvas)bitmapDrawable);
        return bitmap;
    }

    public Bitmap a(Bitmap bitmap, int n2, int n3) {
        int n4 = bitmap.getWidth();
        int n5 = bitmap.getHeight();
        float f2 = (float)n3 / (float)n4;
        float f3 = (float)n2 / (float)n5;
        Matrix matrix = new Matrix();
        matrix.postScale(f2, f3);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n4, (int)n5, (Matrix)matrix, (boolean)false);
        return bitmap2;
    }

    @Override
    public boolean execute(String string2, JSONArray jSONArray, CallbackContext callbackContext) {
        if (string2.equals("startActivity") || string2.equals("startActivityForResult")) {
            if (jSONArray.length() != 1) {
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
                return false;
            }
            JSONObject jSONObject = jSONArray.getJSONObject(0);
            Intent intent = this.b(jSONObject, callbackContext);
            int n2 = jSONObject.has("requestCode") ? jSONObject.getInt("requestCode") : 1;
            boolean bl = false;
            if (string2.equals("startActivityForResult")) {
                bl = true;
                this.c = callbackContext;
            }
            this.a(intent, bl, n2, callbackContext);
            return true;
        }
        if (string2.equals("sendBroadcast")) {
            if (jSONArray.length() != 1) {
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
                return false;
            }
            JSONObject jSONObject = jSONArray.getJSONObject(0);
            Intent intent = this.b(jSONObject, callbackContext);
            this.a(intent);
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK));
            return true;
        }
        if (string2.equals("startService")) {
            if (jSONArray.length() != 1) {
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
                return false;
            }
            JSONObject jSONObject = jSONArray.getJSONObject(0);
            Intent intent = this.b(jSONObject, callbackContext);
            this.b(intent);
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK));
            return true;
        }
        if (string2.equals("registerBroadcastReceiver")) {
            JSONArray jSONArray2;
            JSONArray jSONArray3;
            JSONArray jSONArray4;
            if (jSONArray.length() != 1) {
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
                return false;
            }
            JSONObject jSONObject = jSONArray.getJSONObject(0);
            JSONArray jSONArray5 = jSONArray4 = jSONObject.has("filterActions") ? jSONObject.getJSONArray("filterActions") : null;
            if (jSONArray4 == null || jSONArray4.length() == 0) {
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
                return false;
            }
            this.b = callbackContext;
            PluginResult pluginResult = new PluginResult(PluginResult.Status.NO_RESULT);
            pluginResult.setKeepCallback(true);
            IntentFilter intentFilter = new IntentFilter();
            for (int i2 = 0; i2 < jSONArray4.length(); ++i2) {
                intentFilter.addAction(jSONArray4.getString(i2));
            }
            JSONArray jSONArray6 = jSONArray3 = jSONObject.has("filterCategories") ? jSONObject.getJSONArray("filterCategories") : null;
            if (jSONArray3 != null) {
                for (int i3 = 0; i3 < jSONArray3.length(); ++i3) {
                    intentFilter.addCategory(jSONArray3.getString(i3));
                }
            }
            JSONArray jSONArray7 = jSONArray2 = jSONObject.has("filterDataSchemes") ? jSONObject.getJSONArray("filterDataSchemes") : null;
            if (jSONArray2 != null && jSONArray2.length() > 0) {
                for (int i4 = 0; i4 < jSONArray2.length(); ++i4) {
                    intentFilter.addDataScheme(jSONArray2.getString(i4));
                }
            }
            this.cordova.getActivity().registerReceiver(this.e, intentFilter);
            callbackContext.sendPluginResult(pluginResult);
        } else if (string2.equals("unregisterBroadcastReceiver")) {
            try {
                this.cordova.getActivity().unregisterReceiver(this.e);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            if (string2.equals("onIntent")) {
                if (jSONArray.length() != 1) {
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
                    return false;
                }
                this.a = callbackContext;
                if (this.d != null) {
                    this.c(this.d);
                    this.d = null;
                }
                PluginResult pluginResult = new PluginResult(PluginResult.Status.NO_RESULT);
                pluginResult.setKeepCallback(true);
                callbackContext.sendPluginResult(pluginResult);
                return true;
            }
            if (string2.equals("onActivityResult")) {
                if (jSONArray.length() != 1) {
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
                    return false;
                }
                this.c = callbackContext;
                PluginResult pluginResult = new PluginResult(PluginResult.Status.NO_RESULT);
                pluginResult.setKeepCallback(true);
                callbackContext.sendPluginResult(pluginResult);
                return true;
            }
            if (string2.equals("getIntent")) {
                Object object;
                Intent intent;
                if (jSONArray.length() != 0) {
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
                    return false;
                }
                if (this.d != null) {
                    intent = this.d;
                    this.d = null;
                } else {
                    intent = this.cordova.getActivity().getIntent();
                }
                LauncherApps.PinItemRequest pinItemRequest = (LauncherApps.PinItemRequest)intent.getParcelableExtra("android.content.pm.extra.PIN_ITEM_REQUEST");
                if (pinItemRequest != null) {
                    try {
                        pinItemRequest.accept();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ShortcutInfo shortcutInfo = null;
                try {
                    shortcutInfo = pinItemRequest.getShortcutInfo();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Context context = this.cordova.getActivity().getApplicationContext();
                LauncherApps launcherApps = (LauncherApps)context.getSystemService("launcherapps");
                String string3 = "";
                if (shortcutInfo != null && shortcutInfo.getShortLabel() != null) {
                    string3 = shortcutInfo.getShortLabel().toString();
                }
                String string4 = "";
                if (shortcutInfo != null && shortcutInfo.getId() != null) {
                    string4 = shortcutInfo.getId();
                }
                String string5 = "";
                if (shortcutInfo != null && shortcutInfo.getPackage() != null) {
                    string5 = shortcutInfo.getPackage();
                }
                UserHandle userHandle = null;
                if (shortcutInfo != null && shortcutInfo.getUserHandle() != null) {
                    userHandle = shortcutInfo.getUserHandle();
                }
                String string6 = "";
                int n3 = 0;
                try {
                    object = Parcel.obtain();
                    UserHandle.writeToParcel((UserHandle)userHandle, (Parcel)object);
                    n3 = object.readInt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = "blank";
                String string7 = "";
                try {
                    Bitmap bitmap = IntentShim.a(launcherApps.getShortcutIconDrawable(shortcutInfo, 0));
                    bitmap = this.a(bitmap, 512, 512);
                    string7 = "/data/data/luke.launcher/appicons/";
                    object = "" + System.currentTimeMillis() + ".png";
                    File file = new File(string7, (String)object);
                    FileOutputStream fileOutputStream = null;
                    fileOutputStream = new FileOutputStream(file);
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                }
                catch (Exception exception) {
                    object = "blank";
                }
                string6 = string5 + "|!!|" + string3 + "|!!|" + string7 + (String)object + "|!!|" + string4 + "|!!|" + String.valueOf(n3);
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, string6));
                return true;
            }
            if (string2.equals("sendResult")) {
                Intent intent = new Intent();
                if (jSONArray.length() > 0) {
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jSONArray.getJSONObject(0);
                    JSONObject jSONObject3 = jSONObject = jSONObject2.has("extras") ? jSONObject2.getJSONObject("extras") : null;
                    if (jSONObject != null) {
                        JSONArray jSONArray8 = jSONObject.names();
                        for (int i5 = 0; i5 < jSONArray8.length(); ++i5) {
                            String string8 = jSONArray8.getString(i5);
                            Object object = jSONObject.get(string8);
                            if (object instanceof JSONObject) {
                                Bundle bundle = this.a((JSONObject)jSONObject.get(string8));
                                intent.putExtra(string8, bundle);
                                continue;
                            }
                            if (object instanceof Boolean) {
                                intent.putExtra(string8, jSONObject.getBoolean(string8));
                                continue;
                            }
                            if (object instanceof Integer) {
                                intent.putExtra(string8, jSONObject.getInt(string8));
                                continue;
                            }
                            if (object instanceof Long) {
                                intent.putExtra(string8, jSONObject.getLong(string8));
                                continue;
                            }
                            if (object instanceof Double) {
                                intent.putExtra(string8, jSONObject.getDouble(string8));
                                continue;
                            }
                            if (object instanceof Float) {
                                intent.putExtra(string8, jSONObject.getDouble(string8));
                                continue;
                            }
                            intent.putExtra(string8, jSONObject.getString(string8));
                        }
                    }
                }
                this.cordova.getActivity().setResult(-1, intent);
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK));
                this.cordova.getActivity().finish();
            } else if (string2.equals("realPathFromUri")) {
                if (jSONArray.length() != 1) {
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.INVALID_ACTION));
                    return false;
                }
                JSONObject jSONObject = jSONArray.getJSONObject(0);
                String string9 = this.a(jSONObject, callbackContext);
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, string9));
                return true;
            }
        }
        return true;
    }

    private Uri a(String string2, CallbackContext callbackContext) {
        int n2 = android.support.v4.a.a.b((Context)this.cordova.getActivity(), "android.permission.READ_EXTERNAL_STORAGE");
        if (n2 != 0) {
            android.support.v4.app.a.a(this.cordova.getActivity(), new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 1);
            callbackContext.error("Please grant read external storage permission");
            return null;
        }
        try {
            String string3 = Environment.getExternalStorageState();
            if (string3.equals("mounted") || string3.equals("mounted_ro")) {
                String string4 = string2.substring(string2.indexOf(47) + 2, string2.length());
                File file = new File(string4);
                boolean bl = file.exists();
                if (!bl) {
                    Log.e((String)"Cordova Intents Shim", (String)("File at path " + file.getPath() + " with name " + file.getName() + "does not exist"));
                    callbackContext.error("File not found: " + file.toString());
                    return null;
                }
                String string5 = this.cordova.getActivity().getPackageName() + ".darryncampbell.cordova.plugin.intent.fileprovider";
                Uri uri = android.support.v4.a.b.getUriForFile(this.cordova.getActivity().getApplicationContext(), string5, file);
                return uri;
            }
            Log.e((String)"Cordova Intents Shim", (String)"Storage directory is not mounted.  Please ensure the device is not connected via USB for file transfer");
            callbackContext.error("Storage directory is returning not mounted");
            return null;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            Log.e((String)"Cordova Intents Shim", (String)"URL is not well formed");
            callbackContext.error("URL is not well formed");
            return null;
        }
    }

    private String a(JSONObject jSONObject, CallbackContext callbackContext) {
        Uri uri;
        Uri uri2 = uri = jSONObject.has("uri") ? Uri.parse((String)jSONObject.getString("uri")) : null;
        if (uri == null) {
            Log.w((String)"Cordova Intents Shim", (String)"URI is not a specified parameter");
            throw new JSONException("URI is not a specified parameter");
        }
        if (Build.VERSION.SDK_INT >= 19) {
            String string2 = "";
            if (uri.getHost().contains("com.android.providers.media")) {
                int n2 = android.support.v4.a.a.b((Context)this.cordova.getActivity(), "android.permission.READ_EXTERNAL_STORAGE");
                if (n2 != 0) {
                    android.support.v4.app.a.a(this.cordova.getActivity(), new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 1);
                    callbackContext.error("Please grant read external storage permission");
                    return null;
                }
                String string3 = DocumentsContract.getDocumentId((Uri)uri);
                String string4 = string3.split(":")[1];
                String[] stringArray = new String[]{"_data"};
                String string5 = "_id=?";
                Cursor cursor = this.cordova.getActivity().getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, stringArray, string5, new String[]{string4}, null);
                int n3 = cursor.getColumnIndex(stringArray[0]);
                if (cursor.moveToFirst()) {
                    string2 = cursor.getString(n3);
                }
                cursor.close();
                return string2;
            }
            String[] stringArray = new String[]{"_data"};
            Cursor cursor = this.cordova.getActivity().getApplicationContext().getContentResolver().query(uri, stringArray, null, null, null);
            int n4 = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(n4);
        }
        return "Requires KK or higher";
    }

    private void a(Intent intent, boolean bl, int n2, CallbackContext callbackContext) {
        if (intent.resolveActivityInfo(this.cordova.getActivity().getPackageManager(), 0) != null) {
            if (bl) {
                this.cordova.setActivityResultCallback(this);
                this.cordova.getActivity().startActivityForResult(intent, n2);
            } else {
                this.cordova.getActivity().startActivity(intent);
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK));
            }
        } else {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR));
        }
    }

    private void a(Intent intent) {
        this.cordova.getActivity().sendBroadcast(intent);
    }

    private void b(Intent intent) {
        this.cordova.getActivity().startService(intent);
    }

    private Intent b(JSONObject jSONObject, CallbackContext callbackContext) {
        Object object;
        String string2;
        JSONArray jSONArray;
        String string3;
        String string4 = jSONObject.has("type") ? jSONObject.getString("type") : null;
        String string5 = jSONObject.has("package") ? jSONObject.getString("package") : null;
        Uri uri = null;
        CordovaResourceApi cordovaResourceApi = this.webView.getResourceApi();
        if (jSONObject.has("url")) {
            string3 = jSONObject.getString("url");
            uri = Build.VERSION.SDK_INT >= 24 && string3.startsWith("file://") ? this.a(string3, callbackContext) : cordovaResourceApi.remapUri(Uri.parse((String)jSONObject.getString("url")));
        }
        string3 = jSONObject.has("extras") ? jSONObject.getJSONObject("extras") : null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Bundle bundle = null;
        String string6 = "";
        if (string3 != null) {
            jSONArray = string3.names();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                string2 = jSONArray.getString(i2);
                object = string3.get(string2);
                if (object instanceof JSONObject) {
                    string6 = string2;
                    bundle = this.a((JSONObject)string3.get(string2));
                    continue;
                }
                hashMap.put(string2, string3.get(string2));
            }
        }
        jSONArray = jSONObject.has("action") ? jSONObject.getString("action") : null;
        Intent intent = new Intent();
        if (jSONArray != null) {
            intent.setAction((String)jSONArray);
        }
        if (string4 != null && uri != null) {
            intent.setDataAndType(uri, string4);
        } else {
            if (string4 != null) {
                intent.setType(string4);
            }
            if (uri != null) {
                intent.setData(uri);
            }
        }
        Object object2 = string2 = jSONObject.has("component") ? jSONObject.getJSONObject("component") : null;
        if (string2 != null) {
            Object object3;
            object = string2.has("package") ? string2.getString("package") : null;
            Object object4 = object3 = string2.has("class") ? string2.getString("class") : null;
            if (object == null || object3 == null) {
                Log.w((String)"Cordova Intents Shim", (String)"Component specified but missing corresponding package or class");
                throw new JSONException("Component specified but missing corresponding package or class");
            }
            Object object5 = new ComponentName((String)object, (String)object3);
            intent.setComponent((ComponentName)object5);
        }
        if (string5 != null) {
            intent.setPackage(string5);
        }
        Object object6 = object = jSONObject.has("flags") ? jSONObject.getJSONArray("flags") : null;
        if (object != null) {
            int n2 = object.length();
            for (int i3 = 0; i3 < n2; ++i3) {
                intent.addFlags(object.getInt(i3));
            }
        }
        if (bundle != null) {
            intent.putExtra(string6, bundle);
        }
        for (Object object5 : hashMap.keySet()) {
            Uri uri2;
            Object v2 = hashMap.get(object5);
            String string7 = String.valueOf(v2);
            if (((String)object5).equals("android.intent.extra.TEXT") && string4.equals("text/html")) {
                intent.putExtra((String)object5, (CharSequence)Html.fromHtml((String)string7));
                continue;
            }
            if (((String)object5).equals("android.intent.extra.STREAM")) {
                if (Build.VERSION.SDK_INT >= 24 && string7.startsWith("file://")) {
                    uri2 = this.a(string7, callbackContext);
                    if (uri2 == null) continue;
                    intent.putExtra((String)object5, (Parcelable)uri2);
                    continue;
                }
                intent.putExtra((String)object5, (Parcelable)cordovaResourceApi.remapUri(Uri.parse((String)string7)));
                continue;
            }
            if (((String)object5).equals("android.intent.extra.EMAIL")) {
                intent.putExtra("android.intent.extra.EMAIL", new String[]{string7});
                continue;
            }
            if (((String)object5).equals("android.intent.extra.KEY_EVENT")) {
                uri2 = new JSONObject(string7);
                int n3 = uri2.getInt("action");
                int n4 = uri2.getInt("code");
                KeyEvent keyEvent = new KeyEvent(n3, n4);
                intent.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)keyEvent);
                continue;
            }
            if (v2 instanceof Boolean) {
                intent.putExtra((String)object5, (Serializable)Boolean.valueOf(string7));
                continue;
            }
            if (v2 instanceof Integer) {
                intent.putExtra((String)object5, (Serializable)Integer.valueOf(string7));
                continue;
            }
            if (v2 instanceof Long) {
                intent.putExtra((String)object5, (Serializable)Long.valueOf(string7));
                continue;
            }
            if (v2 instanceof Double) {
                intent.putExtra((String)object5, (Serializable)Double.valueOf(string7));
                continue;
            }
            intent.putExtra((String)object5, string7);
        }
        intent.addFlags(1);
        if (jSONObject.has("chooser")) {
            intent = Intent.createChooser((Intent)intent, (CharSequence)jSONObject.getString("chooser"));
        }
        return intent;
    }

    @Override
    public void onNewIntent(Intent intent) {
        if (this.a != null) {
            this.c(intent);
        } else {
            this.d = intent;
        }
    }

    @Override
    public void onActivityResult(int n2, int n3, Intent intent) {
        super.onActivityResult(n2, n3, intent);
        if (this.c != null && intent != null) {
            intent.putExtra("requestCode", n2);
            intent.putExtra("resultCode", n3);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, this.d(intent));
            pluginResult.setKeepCallback(true);
            this.c.sendPluginResult(pluginResult);
        } else if (this.c != null) {
            Intent intent2 = new Intent();
            intent2.putExtra("requestCode", n2);
            intent2.putExtra("resultCode", n3);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, this.d(intent2));
            pluginResult.setKeepCallback(true);
            this.c.sendPluginResult(pluginResult);
        }
    }

    private void c(Intent intent) {
        PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, this.d(intent));
        pluginResult.setKeepCallback(true);
        this.a.sendPluginResult(pluginResult);
    }

    private JSONObject d(Intent intent) {
        JSONObject jSONObject = null;
        ClipData clipData = null;
        JSONObject[] jSONObjectArray = null;
        ContentResolver contentResolver = this.cordova.getActivity().getApplicationContext().getContentResolver();
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        if (Build.VERSION.SDK_INT >= 19 && (clipData = intent.getClipData()) != null) {
            int n2 = clipData.getItemCount();
            jSONObjectArray = new JSONObject[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                ClipData.Item item = clipData.getItemAt(i2);
                try {
                    jSONObjectArray[i2] = new JSONObject();
                    jSONObjectArray[i2].put("htmlText", (Object)item.getHtmlText());
                    jSONObjectArray[i2].put("intent", (Object)item.getIntent());
                    jSONObjectArray[i2].put("text", (Object)item.getText());
                    jSONObjectArray[i2].put("uri", (Object)item.getUri());
                    if (item.getUri() == null) continue;
                    String string2 = contentResolver.getType(item.getUri());
                    String string3 = mimeTypeMap.getExtensionFromMimeType(contentResolver.getType(item.getUri()));
                    jSONObjectArray[i2].put("type", (Object)string2);
                    jSONObjectArray[i2].put("extension", (Object)string3);
                    continue;
                }
                catch (JSONException jSONException) {
                    Log.d((String)"Cordova Intents Shim", (String)" Error thrown during intent > JSON conversion");
                    Log.d((String)"Cordova Intents Shim", (String)jSONException.getMessage());
                    Log.d((String)"Cordova Intents Shim", (String)Arrays.toString(jSONException.getStackTrace()));
                }
            }
        }
        try {
            jSONObject = new JSONObject();
            if (Build.VERSION.SDK_INT >= 19 && jSONObjectArray != null) {
                jSONObject.put("clipItems", (Object)new JSONArray((Object)jSONObjectArray));
            }
            jSONObject.put("type", (Object)intent.getType());
            jSONObject.put("extras", (Object)IntentShim.a(intent.getExtras()));
            jSONObject.put("action", (Object)intent.getAction());
            jSONObject.put("categories", (Object)intent.getCategories());
            jSONObject.put("flags", intent.getFlags());
            jSONObject.put("component", (Object)intent.getComponent());
            jSONObject.put("data", (Object)intent.getData());
            jSONObject.put("package", (Object)intent.getPackage());
            return jSONObject;
        }
        catch (JSONException jSONException) {
            Log.d((String)"Cordova Intents Shim", (String)" Error thrown during intent > JSON conversion");
            Log.d((String)"Cordova Intents Shim", (String)jSONException.getMessage());
            Log.d((String)"Cordova Intents Shim", (String)Arrays.toString(jSONException.getStackTrace()));
            return null;
        }
    }

    private static JSONObject a(Bundle bundle) {
        try {
            return (JSONObject)IntentShim.a((Object)bundle);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Cannot convert bundle to JSON: " + jSONException.getMessage(), jSONException);
        }
    }

    private static Object a(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Bundle) {
            Bundle bundle = (Bundle)object;
            JSONObject jSONObject = new JSONObject();
            for (String string2 : bundle.keySet()) {
                jSONObject.put(string2, IntentShim.a(bundle.get(string2)));
            }
            return jSONObject;
        }
        if (object.getClass().isArray()) {
            JSONArray jSONArray = new JSONArray();
            int n2 = Array.getLength(object);
            for (int i2 = 0; i2 < n2; ++i2) {
                jSONArray.put(i2, IntentShim.a(Array.get(object, i2)));
            }
            return jSONArray;
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            JSONArray jSONArray = new JSONArray();
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                jSONArray.put(IntentShim.a(arrayList.get(i3)));
            }
            return jSONArray;
        }
        if (object instanceof String || object instanceof Boolean || object instanceof Integer || object instanceof Long || object instanceof Double) {
            return object;
        }
        return String.valueOf(object);
    }

    private Bundle a(JSONObject jSONObject) {
        Bundle bundle = new Bundle();
        if (jSONObject == null) {
            return null;
        }
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object object = jSONObject.get(string2);
                if (jSONObject.get(string2) instanceof String) {
                    bundle.putString(string2, jSONObject.getString(string2));
                    continue;
                }
                if (jSONObject.get(string2) instanceof Boolean) {
                    bundle.putBoolean(string2, jSONObject.getBoolean(string2));
                    continue;
                }
                if (jSONObject.get(string2) instanceof Integer) {
                    bundle.putInt(string2, jSONObject.getInt(string2));
                    continue;
                }
                if (jSONObject.get(string2) instanceof Long) {
                    bundle.putLong(string2, jSONObject.getLong(string2));
                    continue;
                }
                if (jSONObject.get(string2) instanceof Double) {
                    bundle.putDouble(string2, jSONObject.getDouble(string2));
                    continue;
                }
                if (jSONObject.get(string2).getClass().isArray() || jSONObject.get(string2) instanceof JSONArray) {
                    int n2;
                    String[] stringArray;
                    JSONArray jSONArray = jSONObject.getJSONArray(string2);
                    int n3 = jSONArray.length();
                    if (jSONArray.get(0) instanceof String) {
                        stringArray = new String[n3];
                        for (n2 = 0; n2 < n3; ++n2) {
                            stringArray[n2] = jSONArray.getString(n2);
                        }
                        bundle.putStringArray(string2, stringArray);
                        continue;
                    }
                    if (string2.equals("PLUGIN_CONFIG")) {
                        stringArray = new ArrayList();
                        for (n2 = 0; n2 < n3; ++n2) {
                            stringArray.add(this.a(jSONArray.getJSONObject(n2)));
                        }
                        bundle.putParcelableArrayList(string2, (ArrayList)stringArray);
                        continue;
                    }
                    stringArray = new Bundle[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        stringArray[n2] = this.a(jSONArray.getJSONObject(n2));
                    }
                    bundle.putParcelableArray(string2, (Parcelable[])stringArray);
                    continue;
                }
                if (!(jSONObject.get(string2) instanceof JSONObject)) continue;
                bundle.putBundle(string2, this.a((JSONObject)jSONObject.get(string2)));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return bundle;
    }
}

