/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import org.apache.cordova.CordovaWebView;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONObject;

public class CallbackContext {
    private static final String LOG_TAG = "CordovaPlugin";
    private String callbackId;
    private CordovaWebView webView;
    protected boolean finished;
    private int changingThreads;

    public CallbackContext(String string2, CordovaWebView cordovaWebView) {
        this.callbackId = string2;
        this.webView = cordovaWebView;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isChangingThreads() {
        return this.changingThreads > 0;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPluginResult(PluginResult pluginResult) {
        CallbackContext callbackContext = this;
        synchronized (callbackContext) {
            if (this.finished) {
                LOG.w(LOG_TAG, "Attempted to send a second callback for ID: " + this.callbackId + "\nResult was: " + pluginResult.getMessage());
                return;
            }
            this.finished = !pluginResult.getKeepCallback();
        }
        this.webView.sendPluginResult(pluginResult, this.callbackId);
    }

    public void success(JSONObject jSONObject) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, jSONObject));
    }

    public void success(String string2) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, string2));
    }

    public void success(JSONArray jSONArray) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, jSONArray));
    }

    public void success(byte[] byArray) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, byArray));
    }

    public void success(int n2) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, n2));
    }

    public void success() {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK));
    }

    public void error(JSONObject jSONObject) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, jSONObject));
    }

    public void error(String string2) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, string2));
    }

    public void error(int n2) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, n2));
    }
}

