/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.Context;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConfigXmlParser {
    private static String TAG = "ConfigXmlParser";
    private String launchUrl = "file:///android_asset/www/index.html";
    private CordovaPreferences prefs = new CordovaPreferences();
    private ArrayList<PluginEntry> pluginEntries = new ArrayList(20);
    boolean insideFeature = false;
    String service = "";
    String pluginClass = "";
    String paramType = "";
    boolean onload = false;

    public CordovaPreferences getPreferences() {
        return this.prefs;
    }

    public ArrayList<PluginEntry> getPluginEntries() {
        return this.pluginEntries;
    }

    public String getLaunchUrl() {
        return this.launchUrl;
    }

    public void parse(Context context) {
        int n2 = context.getResources().getIdentifier("config", "xml", context.getClass().getPackage().getName());
        if (n2 == 0 && (n2 = context.getResources().getIdentifier("config", "xml", context.getPackageName())) == 0) {
            LOG.e(TAG, "res/xml/config.xml is missing!");
            return;
        }
        this.parse((XmlPullParser)context.getResources().getXml(n2));
    }

    public void parse(XmlPullParser xmlPullParser) {
        int n2 = -1;
        while (n2 != 1) {
            if (n2 == 2) {
                this.handleStartTag(xmlPullParser);
            } else if (n2 == 3) {
                this.handleEndTag(xmlPullParser);
            }
            try {
                n2 = xmlPullParser.next();
            }
            catch (XmlPullParserException xmlPullParserException) {
                xmlPullParserException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void handleStartTag(XmlPullParser xmlPullParser) {
        String string2;
        String string3 = xmlPullParser.getName();
        if (string3.equals("feature")) {
            this.insideFeature = true;
            this.service = xmlPullParser.getAttributeValue(null, "name");
        } else if (this.insideFeature && string3.equals("param")) {
            this.paramType = xmlPullParser.getAttributeValue(null, "name");
            if (this.paramType.equals("service")) {
                this.service = xmlPullParser.getAttributeValue(null, "value");
            } else if (this.paramType.equals("package") || this.paramType.equals("android-package")) {
                this.pluginClass = xmlPullParser.getAttributeValue(null, "value");
            } else if (this.paramType.equals("onload")) {
                this.onload = "true".equals(xmlPullParser.getAttributeValue(null, "value"));
            }
        } else if (string3.equals("preference")) {
            String string4 = xmlPullParser.getAttributeValue(null, "name").toLowerCase(Locale.ENGLISH);
            String string5 = xmlPullParser.getAttributeValue(null, "value");
            this.prefs.set(string4, string5);
        } else if (string3.equals("content") && (string2 = xmlPullParser.getAttributeValue(null, "src")) != null) {
            this.setStartUrl(string2);
        }
    }

    public void handleEndTag(XmlPullParser xmlPullParser) {
        String string2 = xmlPullParser.getName();
        if (string2.equals("feature")) {
            this.pluginEntries.add(new PluginEntry(this.service, this.pluginClass, this.onload));
            this.service = "";
            this.pluginClass = "";
            this.insideFeature = false;
            this.onload = false;
        }
    }

    private void setStartUrl(String string2) {
        Pattern pattern = Pattern.compile("^[a-z-]+://");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            this.launchUrl = string2;
        } else {
            if (string2.charAt(0) == '/') {
                string2 = string2.substring(1);
            }
            this.launchUrl = "file:///android_asset/www/" + string2;
        }
    }
}

