/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.cordova.Config;
import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaInterfaceImpl;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.CordovaWebViewImpl;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginManager;
import org.json.JSONException;
import org.json.JSONObject;

public class CordovaActivity
extends Activity {
    public static String TAG = "CordovaActivity";
    protected CordovaWebView appView;
    private static int ACTIVITY_STARTING = 0;
    private static int ACTIVITY_RUNNING = 1;
    private static int ACTIVITY_EXITING = 2;
    protected boolean keepRunning = true;
    protected boolean immersiveMode;
    protected CordovaPreferences preferences;
    protected String launchUrl;
    protected ArrayList<PluginEntry> pluginEntries;
    protected CordovaInterfaceImpl cordovaInterface;

    public void onCreate(Bundle bundle) {
        this.loadConfig();
        String string2 = this.preferences.getString("loglevel", "ERROR");
        LOG.setLogLevel(string2);
        LOG.i(TAG, "Apache Cordova native platform version 8.1.0 is starting");
        LOG.d(TAG, "CordovaActivity.onCreate()");
        if (!this.preferences.getBoolean("ShowTitle", false)) {
            this.getWindow().requestFeature(1);
        }
        if (this.preferences.getBoolean("SetFullscreen", false)) {
            LOG.d(TAG, "The SetFullscreen configuration is deprecated in favor of Fullscreen, and will be removed in a future version.");
            this.preferences.set("Fullscreen", true);
        }
        if (this.preferences.getBoolean("Fullscreen", false)) {
            if (!this.preferences.getBoolean("FullscreenNotImmersive", false)) {
                this.immersiveMode = true;
            } else {
                this.getWindow().setFlags(1024, 1024);
            }
        } else {
            this.getWindow().setFlags(2048, 2048);
        }
        super.onCreate(bundle);
        this.cordovaInterface = this.makeCordovaInterface();
        if (bundle != null) {
            this.cordovaInterface.restoreInstanceState(bundle);
        }
    }

    protected void init() {
        this.appView = this.makeWebView();
        this.createViews();
        if (!this.appView.isInitialized()) {
            this.appView.init(this.cordovaInterface, this.pluginEntries, this.preferences);
        }
        this.cordovaInterface.onCordovaInit(this.appView.getPluginManager());
        String string2 = this.preferences.getString("DefaultVolumeStream", "");
        if ("media".equals(string2.toLowerCase(Locale.ENGLISH))) {
            this.setVolumeControlStream(3);
        }
    }

    protected void loadConfig() {
        ConfigXmlParser configXmlParser = new ConfigXmlParser();
        configXmlParser.parse((Context)this);
        this.preferences = configXmlParser.getPreferences();
        this.preferences.setPreferencesBundle(this.getIntent().getExtras());
        this.launchUrl = configXmlParser.getLaunchUrl();
        this.pluginEntries = configXmlParser.getPluginEntries();
        Config.parser = configXmlParser;
    }

    protected void createViews() {
        this.appView.getView().setId(100);
        this.appView.getView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.setContentView(this.appView.getView());
        if (this.preferences.contains("BackgroundColor")) {
            try {
                int n2 = this.preferences.getInteger("BackgroundColor", -16777216);
                this.appView.getView().setBackgroundColor(n2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.appView.getView().requestFocusFromTouch();
    }

    protected CordovaWebView makeWebView() {
        return new CordovaWebViewImpl(this.makeWebViewEngine());
    }

    protected CordovaWebViewEngine makeWebViewEngine() {
        return CordovaWebViewImpl.createEngine((Context)this, this.preferences);
    }

    protected CordovaInterfaceImpl makeCordovaInterface() {
        return new CordovaInterfaceImpl(this){

            @Override
            public Object onMessage(String string2, Object object) {
                return CordovaActivity.this.onMessage(string2, object);
            }
        };
    }

    public void loadUrl(String string2) {
        if (this.appView == null) {
            this.init();
        }
        this.keepRunning = this.preferences.getBoolean("KeepRunning", true);
        this.appView.loadUrlIntoView(string2, true);
    }

    protected void onPause() {
        super.onPause();
        LOG.d(TAG, "Paused the activity.");
        if (this.appView != null) {
            boolean bl = this.keepRunning || this.cordovaInterface.activityResultCallback != null;
            this.appView.handlePause(bl);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (this.appView != null) {
            this.appView.onNewIntent(intent);
        }
    }

    protected void onResume() {
        super.onResume();
        LOG.d(TAG, "Resumed the activity.");
        if (this.appView == null) {
            return;
        }
        if (!this.getWindow().getDecorView().hasFocus()) {
            this.getWindow().getDecorView().requestFocus();
        }
        this.appView.handleResume(this.keepRunning);
    }

    protected void onStop() {
        super.onStop();
        LOG.d(TAG, "Stopped the activity.");
        if (this.appView == null) {
            return;
        }
        this.appView.handleStop();
    }

    protected void onStart() {
        super.onStart();
        LOG.d(TAG, "Started the activity.");
        if (this.appView == null) {
            return;
        }
        this.appView.handleStart();
    }

    public void onDestroy() {
        LOG.d(TAG, "CordovaActivity.onDestroy()");
        super.onDestroy();
        if (this.appView != null) {
            this.appView.handleDestroy();
        }
    }

    @SuppressLint(value={"InlinedApi"})
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl && this.immersiveMode) {
            int n2 = 5894;
            this.getWindow().getDecorView().setSystemUiVisibility(5894);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void startActivityForResult(Intent intent, int n2, Bundle bundle) {
        this.cordovaInterface.setActivityResultRequestCode(n2);
        super.startActivityForResult(intent, n2, bundle);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        LOG.d(TAG, "Incoming Result. Request code = " + n2);
        super.onActivityResult(n2, n3, intent);
        this.cordovaInterface.onActivityResult(n2, n3, intent);
    }

    public void onReceivedError(int n2, final String string2, final String string3) {
        final CordovaActivity cordovaActivity = this;
        final String string4 = this.preferences.getString("errorUrl", null);
        if (string4 != null && !string3.equals(string4) && this.appView != null) {
            cordovaActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    cordovaActivity.appView.showWebPage(string4, false, true, null);
                }
            });
        } else {
            final boolean bl = n2 != -2;
            cordovaActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        cordovaActivity.appView.getView().setVisibility(8);
                        cordovaActivity.displayError("Application Error", string2 + " (" + string3 + ")", "OK", bl);
                    }
                }
            });
        }
    }

    public void displayError(final String string2, final String string3, final String string4, final boolean bl) {
        final CordovaActivity cordovaActivity = this;
        cordovaActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)cordovaActivity);
                    builder.setMessage((CharSequence)string3);
                    builder.setTitle((CharSequence)string2);
                    builder.setCancelable(false);
                    builder.setPositiveButton((CharSequence)string4, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int n2) {
                            dialogInterface.dismiss();
                            if (bl) {
                                CordovaActivity.this.finish();
                            }
                        }
                    });
                    builder.create();
                    builder.show();
                }
                catch (Exception exception) {
                    CordovaActivity.this.finish();
                }
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        if (this.appView != null) {
            this.appView.getPluginManager().postMessage("onCreateOptionsMenu", menu);
        }
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        if (this.appView != null) {
            this.appView.getPluginManager().postMessage("onPrepareOptionsMenu", menu);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (this.appView != null) {
            this.appView.getPluginManager().postMessage("onOptionsItemSelected", menuItem);
        }
        return true;
    }

    public Object onMessage(String string2, Object object) {
        if ("onReceivedError".equals(string2)) {
            JSONObject jSONObject = (JSONObject)object;
            try {
                this.onReceivedError(jSONObject.getInt("errorCode"), jSONObject.getString("description"), jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        } else if ("exit".equals(string2)) {
            this.finish();
        }
        return null;
    }

    protected void onSaveInstanceState(Bundle bundle) {
        this.cordovaInterface.onSaveInstanceState(bundle);
        super.onSaveInstanceState(bundle);
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.appView == null) {
            return;
        }
        PluginManager pluginManager = this.appView.getPluginManager();
        if (pluginManager != null) {
            pluginManager.onConfigurationChanged(configuration);
        }
    }

    public void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray) {
        try {
            this.cordovaInterface.onRequestPermissionResult(n2, stringArray, nArray);
        }
        catch (JSONException jSONException) {
            LOG.d(TAG, "JSONException: Parameters fed into the method are not valid");
            jSONException.printStackTrace();
        }
    }
}

