/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import java.security.SecureRandom;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.LOG;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginManager;
import org.json.JSONArray;
import org.json.JSONException;

public class CordovaBridge {
    private static final String LOG_TAG = "CordovaBridge";
    private PluginManager pluginManager;
    private NativeToJsMessageQueue jsMessageQueue;
    private volatile int expectedBridgeSecret = -1;

    public CordovaBridge(PluginManager pluginManager, NativeToJsMessageQueue nativeToJsMessageQueue) {
        this.pluginManager = pluginManager;
        this.jsMessageQueue = nativeToJsMessageQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsExec(int n2, String string2, String string3, String string4, String string5) {
        if (!this.verifySecret("exec()", n2)) {
            return null;
        }
        if (string5 == null) {
            return "@Null arguments.";
        }
        this.jsMessageQueue.setPaused(true);
        try {
            CordovaResourceApi.jsThread = Thread.currentThread();
            this.pluginManager.exec(string2, string3, string4, string5);
            String string6 = null;
            String string7 = string6 = this.jsMessageQueue.popAndEncode(false);
            return string7;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string8 = "";
            return string8;
        }
        finally {
            this.jsMessageQueue.setPaused(false);
        }
    }

    public void jsSetNativeToJsBridgeMode(int n2, int n3) {
        if (!this.verifySecret("setNativeToJsBridgeMode()", n2)) {
            return;
        }
        this.jsMessageQueue.setBridgeMode(n3);
    }

    public String jsRetrieveJsMessages(int n2, boolean bl) {
        if (!this.verifySecret("retrieveJsMessages()", n2)) {
            return null;
        }
        return this.jsMessageQueue.popAndEncode(bl);
    }

    private boolean verifySecret(String string2, int n2) {
        if (!this.jsMessageQueue.isBridgeEnabled()) {
            if (n2 == -1) {
                LOG.d(LOG_TAG, string2 + " call made before bridge was enabled.");
            } else {
                LOG.d(LOG_TAG, "Ignoring " + string2 + " from previous page load.");
            }
            return false;
        }
        if (this.expectedBridgeSecret < 0 || n2 != this.expectedBridgeSecret) {
            LOG.e(LOG_TAG, "Bridge access attempt with wrong secret token, possibly from malicious code. Disabling exec() bridge!");
            this.clearBridgeSecret();
            throw new IllegalAccessException();
        }
        return true;
    }

    void clearBridgeSecret() {
        this.expectedBridgeSecret = -1;
    }

    public boolean isSecretEstablished() {
        return this.expectedBridgeSecret != -1;
    }

    @SuppressLint(value={"TrulyRandom"})
    int generateBridgeSecret() {
        SecureRandom secureRandom = new SecureRandom();
        this.expectedBridgeSecret = secureRandom.nextInt(Integer.MAX_VALUE);
        return this.expectedBridgeSecret;
    }

    public void reset() {
        this.jsMessageQueue.reset();
        this.clearBridgeSecret();
    }

    public String promptOnJsPrompt(String string2, String string3, String string4) {
        if (string4 != null && string4.length() > 3 && string4.startsWith("gap:")) {
            try {
                JSONArray jSONArray = new JSONArray(string4.substring(4));
                int n2 = jSONArray.getInt(0);
                String string5 = jSONArray.getString(1);
                String string6 = jSONArray.getString(2);
                String string7 = jSONArray.getString(3);
                String string8 = this.jsExec(n2, string5, string6, string7, string3);
                return string8 == null ? "" : string8;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return "";
        }
        if (string4 != null && string4.startsWith("gap_bridge_mode:")) {
            try {
                int n3 = Integer.parseInt(string4.substring(16));
                this.jsSetNativeToJsBridgeMode(n3, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return "";
        }
        if (string4 != null && string4.startsWith("gap_poll:")) {
            int n4 = Integer.parseInt(string4.substring(9));
            try {
                String string9 = this.jsRetrieveJsMessages(n4, "1".equals(string3));
                return string9 == null ? "" : string9;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return "";
            }
        }
        if (string4 != null && string4.startsWith("gap_init:")) {
            if (this.pluginManager.shouldAllowBridgeAccess(string2)) {
                int n5 = Integer.parseInt(string4.substring(9));
                this.jsMessageQueue.setBridgeMode(n5);
                int n6 = this.generateBridgeSecret();
                return "" + n6;
            }
            LOG.e(LOG_TAG, "gap_init called from restricted origin: " + string2);
            return "";
        }
        return null;
    }
}

