/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.CoreAndroid;
import org.apache.cordova.ICordovaCookieManager;
import org.apache.cordova.LOG;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.engine.SystemWebViewEngine;
import org.json.JSONException;
import org.json.JSONObject;

public class CordovaWebViewImpl
implements CordovaWebView {
    public static final String TAG = "CordovaWebViewImpl";
    private PluginManager pluginManager;
    protected final CordovaWebViewEngine engine;
    private CordovaInterface cordova;
    private int loadUrlTimeout = 0;
    private CordovaResourceApi resourceApi;
    private CordovaPreferences preferences;
    private CoreAndroid appPlugin;
    private NativeToJsMessageQueue nativeToJsMessageQueue;
    private EngineClient engineClient = new EngineClient();
    private boolean hasPausedEver;
    String loadedUrl;
    private View mCustomView;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private Set<Integer> boundKeyCodes = new HashSet<Integer>();

    public static CordovaWebViewEngine createEngine(Context context, CordovaPreferences cordovaPreferences) {
        String string2 = cordovaPreferences.getString("webview", SystemWebViewEngine.class.getCanonicalName());
        try {
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(Context.class, CordovaPreferences.class);
            return (CordovaWebViewEngine)constructor.newInstance(context, cordovaPreferences);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create webview. ", exception);
        }
    }

    public CordovaWebViewImpl(CordovaWebViewEngine cordovaWebViewEngine) {
        this.engine = cordovaWebViewEngine;
    }

    public void init(CordovaInterface cordovaInterface) {
        this.init(cordovaInterface, new ArrayList<PluginEntry>(), new CordovaPreferences());
    }

    @Override
    @SuppressLint(value={"Assert"})
    public void init(CordovaInterface cordovaInterface, List<PluginEntry> list, CordovaPreferences cordovaPreferences) {
        if (this.cordova != null) {
            throw new IllegalStateException();
        }
        this.cordova = cordovaInterface;
        this.preferences = cordovaPreferences;
        this.pluginManager = new PluginManager(this, this.cordova, list);
        this.resourceApi = new CordovaResourceApi(this.engine.getView().getContext(), this.pluginManager);
        this.nativeToJsMessageQueue = new NativeToJsMessageQueue();
        this.nativeToJsMessageQueue.addBridgeMode(new NativeToJsMessageQueue.NoOpBridgeMode());
        this.nativeToJsMessageQueue.addBridgeMode(new NativeToJsMessageQueue.LoadUrlBridgeMode(this.engine, cordovaInterface));
        if (cordovaPreferences.getBoolean("DisallowOverscroll", false)) {
            this.engine.getView().setOverScrollMode(2);
        }
        this.engine.init(this, cordovaInterface, this.engineClient, this.resourceApi, this.pluginManager, this.nativeToJsMessageQueue);
        assert (this.engine.getView() instanceof CordovaWebViewEngine.EngineView);
        this.pluginManager.addService("CoreAndroid", "org.apache.cordova.CoreAndroid");
        this.pluginManager.init();
    }

    @Override
    public boolean isInitialized() {
        return this.cordova != null;
    }

    @Override
    public void loadUrlIntoView(final String string2, boolean bl) {
        LOG.d(TAG, ">>> loadUrl(" + string2 + ")");
        if (string2.equals("about:blank") || string2.startsWith("javascript:")) {
            this.engine.loadUrl(string2, false);
            return;
        }
        boolean bl2 = bl = bl || this.loadedUrl == null;
        if (bl) {
            if (this.loadedUrl != null) {
                this.appPlugin = null;
                this.pluginManager.init();
            }
            this.loadedUrl = string2;
        }
        final int n2 = this.loadUrlTimeout;
        final int n3 = this.preferences.getInteger("LoadUrlTimeoutValue", 20000);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CordovaWebViewImpl.this.stopLoading();
                LOG.e(CordovaWebViewImpl.TAG, "CordovaWebView: TIMEOUT ERROR!");
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("errorCode", -6);
                    jSONObject.put("description", (Object)"The connection to the server was unsuccessful.");
                    jSONObject.put("url", (Object)string2);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                CordovaWebViewImpl.this.pluginManager.postMessage("onReceivedError", jSONObject);
            }
        };
        final Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait(n3);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (CordovaWebViewImpl.this.loadUrlTimeout == n2) {
                    CordovaWebViewImpl.this.cordova.getActivity().runOnUiThread(runnable);
                }
            }
        };
        final boolean bl3 = bl;
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (n3 > 0) {
                    CordovaWebViewImpl.this.cordova.getThreadPool().execute(runnable2);
                }
                CordovaWebViewImpl.this.engine.loadUrl(string2, bl3);
            }
        });
    }

    @Override
    public void loadUrl(String string2) {
        this.loadUrlIntoView(string2, true);
    }

    @Override
    public void showWebPage(String string2, boolean bl, boolean bl2, Map<String, Object> map) {
        LOG.d(TAG, "showWebPage(%s, %b, %b, HashMap)", string2, bl, bl2);
        if (bl2) {
            this.engine.clearHistory();
        }
        if (!bl) {
            if (this.pluginManager.shouldAllowNavigation(string2)) {
                this.loadUrlIntoView(string2, true);
                return;
            }
            LOG.w(TAG, "showWebPage: Refusing to load URL into webview since it is not in the <allow-navigation> whitelist. URL=" + string2);
            return;
        }
        if (!this.pluginManager.shouldOpenExternalUrl(string2).booleanValue()) {
            LOG.w(TAG, "showWebPage: Refusing to send intent for URL since it is not in the <allow-intent> whitelist. URL=" + string2);
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addCategory("android.intent.category.BROWSABLE");
            Uri uri = Uri.parse((String)string2);
            if ("file".equals(uri.getScheme())) {
                intent.setDataAndType(uri, this.resourceApi.getMimeType(uri));
            } else {
                intent.setData(uri);
            }
            this.cordova.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            LOG.e(TAG, "Error loading url " + string2, activityNotFoundException);
        }
    }

    @Override
    @Deprecated
    public void showCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        LOG.d(TAG, "showing Custom View");
        if (this.mCustomView != null) {
            customViewCallback.onCustomViewHidden();
            return;
        }
        this.mCustomView = view;
        this.mCustomViewCallback = customViewCallback;
        ViewGroup viewGroup = (ViewGroup)this.engine.getView().getParent();
        viewGroup.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        this.engine.getView().setVisibility(8);
        viewGroup.setVisibility(0);
        viewGroup.bringToFront();
    }

    @Override
    @Deprecated
    public void hideCustomView() {
        if (this.mCustomView == null) {
            return;
        }
        LOG.d(TAG, "Hiding Custom View");
        this.mCustomView.setVisibility(8);
        ViewGroup viewGroup = (ViewGroup)this.engine.getView().getParent();
        viewGroup.removeView(this.mCustomView);
        this.mCustomView = null;
        this.mCustomViewCallback.onCustomViewHidden();
        this.engine.getView().setVisibility(0);
    }

    @Override
    @Deprecated
    public boolean isCustomViewShowing() {
        return this.mCustomView != null;
    }

    @Override
    @Deprecated
    public void sendJavascript(String string2) {
        this.nativeToJsMessageQueue.addJavaScript(string2);
    }

    @Override
    public void sendPluginResult(PluginResult pluginResult, String string2) {
        this.nativeToJsMessageQueue.addPluginResult(pluginResult, string2);
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public CordovaPreferences getPreferences() {
        return this.preferences;
    }

    @Override
    public ICordovaCookieManager getCookieManager() {
        return this.engine.getCookieManager();
    }

    @Override
    public CordovaResourceApi getResourceApi() {
        return this.resourceApi;
    }

    @Override
    public CordovaWebViewEngine getEngine() {
        return this.engine;
    }

    @Override
    public View getView() {
        return this.engine.getView();
    }

    @Override
    public Context getContext() {
        return this.engine.getView().getContext();
    }

    private void sendJavascriptEvent(String string2) {
        if (this.appPlugin == null) {
            this.appPlugin = (CoreAndroid)this.pluginManager.getPlugin("CoreAndroid");
        }
        if (this.appPlugin == null) {
            LOG.w(TAG, "Unable to fire event without existing plugin");
            return;
        }
        this.appPlugin.fireJavascriptEvent(string2);
    }

    @Override
    public void setButtonPlumbedToJs(int n2, boolean bl) {
        switch (n2) {
            case 4: 
            case 24: 
            case 25: 
            case 82: {
                if (bl) {
                    this.boundKeyCodes.add(n2);
                } else {
                    this.boundKeyCodes.remove(n2);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported keycode: " + n2);
    }

    @Override
    public boolean isButtonPlumbedToJs(int n2) {
        return this.boundKeyCodes.contains(n2);
    }

    @Override
    public Object postMessage(String string2, Object object) {
        return this.pluginManager.postMessage(string2, object);
    }

    @Override
    public String getUrl() {
        return this.engine.getUrl();
    }

    @Override
    public void stopLoading() {
        ++this.loadUrlTimeout;
    }

    @Override
    public boolean canGoBack() {
        return this.engine.canGoBack();
    }

    @Override
    public void clearCache() {
        this.engine.clearCache();
    }

    @Override
    @Deprecated
    public void clearCache(boolean bl) {
        this.engine.clearCache();
    }

    @Override
    public void clearHistory() {
        this.engine.clearHistory();
    }

    @Override
    public boolean backHistory() {
        return this.engine.goBack();
    }

    @Override
    public void onNewIntent(Intent intent) {
        if (this.pluginManager != null) {
            this.pluginManager.onNewIntent(intent);
        }
    }

    @Override
    public void handlePause(boolean bl) {
        if (!this.isInitialized()) {
            return;
        }
        this.hasPausedEver = true;
        this.pluginManager.onPause(bl);
        this.sendJavascriptEvent("pause");
        if (!bl) {
            this.engine.setPaused(true);
        }
    }

    @Override
    public void handleResume(boolean bl) {
        if (!this.isInitialized()) {
            return;
        }
        this.engine.setPaused(false);
        this.pluginManager.onResume(bl);
        if (this.hasPausedEver) {
            this.sendJavascriptEvent("resume");
        }
    }

    @Override
    public void handleStart() {
        if (!this.isInitialized()) {
            return;
        }
        this.pluginManager.onStart();
    }

    @Override
    public void handleStop() {
        if (!this.isInitialized()) {
            return;
        }
        this.pluginManager.onStop();
    }

    @Override
    public void handleDestroy() {
        if (!this.isInitialized()) {
            return;
        }
        ++this.loadUrlTimeout;
        this.pluginManager.onDestroy();
        this.loadUrl("about:blank");
        this.engine.destroy();
        this.hideCustomView();
    }

    protected class EngineClient
    implements CordovaWebViewEngine.Client {
        protected EngineClient() {
        }

        @Override
        public void clearLoadTimeoutTimer() {
            CordovaWebViewImpl.this.loadUrlTimeout++;
        }

        @Override
        public void onPageStarted(String string2) {
            LOG.d(CordovaWebViewImpl.TAG, "onPageDidNavigate(" + string2 + ")");
            CordovaWebViewImpl.this.boundKeyCodes.clear();
            CordovaWebViewImpl.this.pluginManager.onReset();
            CordovaWebViewImpl.this.pluginManager.postMessage("onPageStarted", string2);
        }

        @Override
        public void onReceivedError(int n2, String string2, String string3) {
            this.clearLoadTimeoutTimer();
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("errorCode", n2);
                jSONObject.put("description", (Object)string2);
                jSONObject.put("url", (Object)string3);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            CordovaWebViewImpl.this.pluginManager.postMessage("onReceivedError", jSONObject);
        }

        @Override
        public void onPageFinishedLoading(String string2) {
            LOG.d(CordovaWebViewImpl.TAG, "onPageFinished(" + string2 + ")");
            this.clearLoadTimeoutTimer();
            CordovaWebViewImpl.this.pluginManager.postMessage("onPageFinished", string2);
            if (CordovaWebViewImpl.this.engine.getView().getVisibility() != 0) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(2000L);
                            CordovaWebViewImpl.this.cordova.getActivity().runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    CordovaWebViewImpl.this.pluginManager.postMessage("spinner", "stop");
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                thread.start();
            }
            if (string2.equals("about:blank")) {
                CordovaWebViewImpl.this.pluginManager.postMessage("exit", null);
            }
        }

        @Override
        public Boolean onDispatchKeyEvent(KeyEvent keyEvent) {
            boolean bl;
            int n2 = keyEvent.getKeyCode();
            boolean bl2 = bl = n2 == 4;
            if (keyEvent.getAction() == 0) {
                if (bl && CordovaWebViewImpl.this.mCustomView != null) {
                    return true;
                }
                if (CordovaWebViewImpl.this.boundKeyCodes.contains(n2)) {
                    return true;
                }
                if (bl) {
                    return CordovaWebViewImpl.this.engine.canGoBack();
                }
            } else if (keyEvent.getAction() == 1) {
                if (bl && CordovaWebViewImpl.this.mCustomView != null) {
                    CordovaWebViewImpl.this.hideCustomView();
                    return true;
                }
                if (CordovaWebViewImpl.this.boundKeyCodes.contains(n2)) {
                    String string2 = null;
                    switch (n2) {
                        case 25: {
                            string2 = "volumedownbutton";
                            break;
                        }
                        case 24: {
                            string2 = "volumeupbutton";
                            break;
                        }
                        case 84: {
                            string2 = "searchbutton";
                            break;
                        }
                        case 82: {
                            string2 = "menubutton";
                            break;
                        }
                        case 4: {
                            string2 = "backbutton";
                        }
                    }
                    if (string2 != null) {
                        CordovaWebViewImpl.this.sendJavascriptEvent(string2);
                        return true;
                    }
                } else if (bl) {
                    return CordovaWebViewImpl.this.engine.goBack();
                }
            }
            return null;
        }

        @Override
        public boolean onNavigationAttempt(String string2) {
            if (CordovaWebViewImpl.this.pluginManager.onOverrideUrlLoading(string2)) {
                return true;
            }
            if (CordovaWebViewImpl.this.pluginManager.shouldAllowNavigation(string2)) {
                return false;
            }
            if (CordovaWebViewImpl.this.pluginManager.shouldOpenExternalUrl(string2).booleanValue()) {
                CordovaWebViewImpl.this.showWebPage(string2, true, false, null);
                return true;
            }
            LOG.w(CordovaWebViewImpl.TAG, "Blocked (possibly sub-frame) navigation to non-allowed URL: " + string2);
            return true;
        }
    }
}

