/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;

public class NativeToJsMessageQueue {
    private static final String LOG_TAG = "JsMessageQueue";
    private static final boolean FORCE_ENCODE_USING_EVAL = false;
    static final boolean DISABLE_EXEC_CHAINING = false;
    private static int MAX_PAYLOAD_SIZE = 524288000;
    private boolean paused;
    private final LinkedList<JsMessage> queue = new LinkedList();
    private ArrayList<BridgeMode> bridgeModes = new ArrayList();
    private BridgeMode activeBridgeMode;

    public void addBridgeMode(BridgeMode bridgeMode) {
        this.bridgeModes.add(bridgeMode);
    }

    public boolean isBridgeEnabled() {
        return this.activeBridgeMode != null;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBridgeMode(int n2) {
        if (n2 < -1 || n2 >= this.bridgeModes.size()) {
            LOG.d(LOG_TAG, "Invalid NativeToJsBridgeMode: " + n2);
        } else {
            BridgeMode bridgeMode;
            BridgeMode bridgeMode2 = bridgeMode = n2 < 0 ? null : this.bridgeModes.get(n2);
            if (bridgeMode != this.activeBridgeMode) {
                LOG.d(LOG_TAG, "Set native->JS mode to " + (bridgeMode == null ? "null" : bridgeMode.getClass().getSimpleName()));
                NativeToJsMessageQueue nativeToJsMessageQueue = this;
                synchronized (nativeToJsMessageQueue) {
                    this.activeBridgeMode = bridgeMode;
                    if (bridgeMode != null) {
                        bridgeMode.reset();
                        if (!this.paused && !this.queue.isEmpty()) {
                            bridgeMode.onNativeToJsMessageAvailable(this);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            this.queue.clear();
            this.setBridgeMode(-1);
        }
    }

    private int calculatePackedMessageLength(JsMessage jsMessage) {
        int n2 = jsMessage.calculateEncodedLength();
        String string2 = String.valueOf(n2);
        return string2.length() + n2 + 1;
    }

    private void packMessage(JsMessage jsMessage, StringBuilder stringBuilder) {
        int n2 = jsMessage.calculateEncodedLength();
        stringBuilder.append(n2).append(' ');
        jsMessage.encodeAsMessage(stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String popAndEncode(boolean bl) {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            if (this.activeBridgeMode == null) {
                return null;
            }
            this.activeBridgeMode.notifyOfFlush(this, bl);
            if (this.queue.isEmpty()) {
                return null;
            }
            int n2 = 0;
            int n3 = 0;
            for (JsMessage jsMessage : this.queue) {
                int n4 = this.calculatePackedMessageLength(jsMessage);
                if (n3 > 0 && n2 + n4 > MAX_PAYLOAD_SIZE && MAX_PAYLOAD_SIZE > 0) break;
                n2 += n4;
                ++n3;
            }
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i2 = 0; i2 < n3; ++i2) {
                JsMessage jsMessage = this.queue.removeFirst();
                this.packMessage(jsMessage, stringBuilder);
            }
            if (!this.queue.isEmpty()) {
                stringBuilder.append('*');
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String popAndEncodeAsJs() {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            int string2;
            int n3 = this.queue.size();
            if (n3 == 0) {
                return null;
            }
            int n4 = 0;
            int n5 = 0;
            for (JsMessage object2 : this.queue) {
                string2 = object2.calculateEncodedLength() + 50;
                if (n5 > 0 && n4 + string2 > MAX_PAYLOAD_SIZE && MAX_PAYLOAD_SIZE > 0) break;
                n4 += string2;
                ++n5;
            }
            boolean bl = n5 == this.queue.size();
            StringBuilder stringBuilder = new StringBuilder(n4 + (bl ? 0 : 100));
            for (string2 = 0; string2 < n5; ++string2) {
                JsMessage jsMessage = this.queue.removeFirst();
                if (bl && string2 + 1 == n5) {
                    jsMessage.encodeAsJsMessage(stringBuilder);
                    continue;
                }
                stringBuilder.append("try{");
                jsMessage.encodeAsJsMessage(stringBuilder);
                stringBuilder.append("}finally{");
            }
            if (!bl) {
                stringBuilder.append("window.setTimeout(function(){cordova.require('cordova/plugin/android/polling').pollOnce();},0);");
            }
            int n2 = string2 = bl ? 1 : 0;
            while (string2 < n5) {
                stringBuilder.append('}');
                ++string2;
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
    }

    public void addJavaScript(String string2) {
        this.enqueueMessage(new JsMessage(string2));
    }

    public void addPluginResult(PluginResult pluginResult, String string2) {
        if (string2 == null) {
            LOG.e(LOG_TAG, "Got plugin result with no callbackId", new Throwable());
            return;
        }
        boolean bl = pluginResult.getStatus() == PluginResult.Status.NO_RESULT.ordinal();
        boolean bl2 = pluginResult.getKeepCallback();
        if (bl && bl2) {
            return;
        }
        JsMessage jsMessage = new JsMessage(pluginResult, string2);
        this.enqueueMessage(jsMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessage(JsMessage jsMessage) {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            if (this.activeBridgeMode == null) {
                LOG.d(LOG_TAG, "Dropping Native->JS message due to disabled bridge");
                return;
            }
            this.queue.add(jsMessage);
            if (!this.paused) {
                this.activeBridgeMode.onNativeToJsMessageAvailable(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean bl) {
        if (this.paused && bl) {
            LOG.e(LOG_TAG, "nested call to setPaused detected.", new Throwable());
        }
        this.paused = bl;
        if (!bl) {
            NativeToJsMessageQueue nativeToJsMessageQueue = this;
            synchronized (nativeToJsMessageQueue) {
                if (!this.queue.isEmpty() && this.activeBridgeMode != null) {
                    this.activeBridgeMode.onNativeToJsMessageAvailable(this);
                }
            }
        }
    }

    private static class JsMessage {
        final String jsPayloadOrCallbackId;
        final PluginResult pluginResult;

        JsMessage(String string2) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            this.jsPayloadOrCallbackId = string2;
            this.pluginResult = null;
        }

        JsMessage(PluginResult pluginResult, String string2) {
            if (string2 == null || pluginResult == null) {
                throw new NullPointerException();
            }
            this.jsPayloadOrCallbackId = string2;
            this.pluginResult = pluginResult;
        }

        static int calculateEncodedLengthHelper(PluginResult pluginResult) {
            switch (pluginResult.getMessageType()) {
                case 4: 
                case 5: {
                    return 1;
                }
                case 3: {
                    return 1 + pluginResult.getMessage().length();
                }
                case 1: {
                    return 1 + pluginResult.getStrMessage().length();
                }
                case 7: {
                    return 1 + pluginResult.getMessage().length();
                }
                case 6: {
                    return 1 + pluginResult.getMessage().length();
                }
                case 8: {
                    int n2 = 1;
                    for (int i2 = 0; i2 < pluginResult.getMultipartMessagesSize(); ++i2) {
                        int n3 = JsMessage.calculateEncodedLengthHelper(pluginResult.getMultipartMessage(i2));
                        int n4 = String.valueOf(n3).length();
                        n2 += n4 + 1 + n3;
                    }
                    return n2;
                }
            }
            return pluginResult.getMessage().length();
        }

        int calculateEncodedLength() {
            if (this.pluginResult == null) {
                return this.jsPayloadOrCallbackId.length() + 1;
            }
            int n2 = String.valueOf(this.pluginResult.getStatus()).length();
            int n3 = 2 + n2 + 1 + this.jsPayloadOrCallbackId.length() + 1;
            return n3 + JsMessage.calculateEncodedLengthHelper(this.pluginResult);
        }

        static void encodeAsMessageHelper(StringBuilder stringBuilder, PluginResult pluginResult) {
            switch (pluginResult.getMessageType()) {
                case 4: {
                    stringBuilder.append(pluginResult.getMessage().charAt(0));
                    break;
                }
                case 5: {
                    stringBuilder.append('N');
                    break;
                }
                case 3: {
                    stringBuilder.append('n').append(pluginResult.getMessage());
                    break;
                }
                case 1: {
                    stringBuilder.append('s');
                    stringBuilder.append(pluginResult.getStrMessage());
                    break;
                }
                case 7: {
                    stringBuilder.append('S');
                    stringBuilder.append(pluginResult.getMessage());
                    break;
                }
                case 6: {
                    stringBuilder.append('A');
                    stringBuilder.append(pluginResult.getMessage());
                    break;
                }
                case 8: {
                    stringBuilder.append('M');
                    for (int i2 = 0; i2 < pluginResult.getMultipartMessagesSize(); ++i2) {
                        PluginResult pluginResult2 = pluginResult.getMultipartMessage(i2);
                        stringBuilder.append(String.valueOf(JsMessage.calculateEncodedLengthHelper(pluginResult2)));
                        stringBuilder.append(' ');
                        JsMessage.encodeAsMessageHelper(stringBuilder, pluginResult2);
                    }
                    break;
                }
                default: {
                    stringBuilder.append(pluginResult.getMessage());
                }
            }
        }

        void encodeAsMessage(StringBuilder stringBuilder) {
            if (this.pluginResult == null) {
                stringBuilder.append('J').append(this.jsPayloadOrCallbackId);
                return;
            }
            int n2 = this.pluginResult.getStatus();
            boolean bl = n2 == PluginResult.Status.NO_RESULT.ordinal();
            boolean bl2 = n2 == PluginResult.Status.OK.ordinal();
            boolean bl3 = this.pluginResult.getKeepCallback();
            stringBuilder.append(bl || bl2 ? (char)'S' : 'F').append(bl3 ? (char)'1' : '0').append(n2).append(' ').append(this.jsPayloadOrCallbackId).append(' ');
            JsMessage.encodeAsMessageHelper(stringBuilder, this.pluginResult);
        }

        void buildJsMessage(StringBuilder stringBuilder) {
            switch (this.pluginResult.getMessageType()) {
                case 8: {
                    int n2 = this.pluginResult.getMultipartMessagesSize();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PluginResult pluginResult = this.pluginResult.getMultipartMessage(i2);
                        JsMessage jsMessage = new JsMessage(pluginResult, this.jsPayloadOrCallbackId);
                        jsMessage.buildJsMessage(stringBuilder);
                        if (i2 >= n2 - 1) continue;
                        stringBuilder.append(",");
                    }
                    break;
                }
                case 7: {
                    stringBuilder.append("atob('").append(this.pluginResult.getMessage()).append("')");
                    break;
                }
                case 6: {
                    stringBuilder.append("cordova.require('cordova/base64').toArrayBuffer('").append(this.pluginResult.getMessage()).append("')");
                    break;
                }
                case 5: {
                    stringBuilder.append("null");
                    break;
                }
                default: {
                    stringBuilder.append(this.pluginResult.getMessage());
                }
            }
        }

        void encodeAsJsMessage(StringBuilder stringBuilder) {
            if (this.pluginResult == null) {
                stringBuilder.append(this.jsPayloadOrCallbackId);
            } else {
                int n2 = this.pluginResult.getStatus();
                boolean bl = n2 == PluginResult.Status.OK.ordinal() || n2 == PluginResult.Status.NO_RESULT.ordinal();
                stringBuilder.append("cordova.callbackFromNative('").append(this.jsPayloadOrCallbackId).append("',").append(bl).append(",").append(n2).append(",[");
                this.buildJsMessage(stringBuilder);
                stringBuilder.append("],").append(this.pluginResult.getKeepCallback()).append(");");
            }
        }
    }

    public static class EvalBridgeMode
    extends BridgeMode {
        private final CordovaWebViewEngine engine;
        private final CordovaInterface cordova;

        public EvalBridgeMode(CordovaWebViewEngine cordovaWebViewEngine, CordovaInterface cordovaInterface) {
            this.engine = cordovaWebViewEngine;
            this.cordova = cordovaInterface;
        }

        @Override
        public void onNativeToJsMessageAvailable(final NativeToJsMessageQueue nativeToJsMessageQueue) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String string2 = nativeToJsMessageQueue.popAndEncodeAsJs();
                    if (string2 != null) {
                        engine.evaluateJavascript(string2, null);
                    }
                }
            });
        }
    }

    public static class OnlineEventsBridgeMode
    extends BridgeMode {
        private final OnlineEventsBridgeModeDelegate delegate;
        private boolean online;
        private boolean ignoreNextFlush;

        public OnlineEventsBridgeMode(OnlineEventsBridgeModeDelegate onlineEventsBridgeModeDelegate) {
            this.delegate = onlineEventsBridgeModeDelegate;
        }

        @Override
        public void reset() {
            this.delegate.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    online = false;
                    ignoreNextFlush = true;
                    delegate.setNetworkAvailable(true);
                }
            });
        }

        @Override
        public void onNativeToJsMessageAvailable(final NativeToJsMessageQueue nativeToJsMessageQueue) {
            this.delegate.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!nativeToJsMessageQueue.isEmpty()) {
                        ignoreNextFlush = false;
                        delegate.setNetworkAvailable(online);
                    }
                }
            });
        }

        @Override
        public void notifyOfFlush(NativeToJsMessageQueue nativeToJsMessageQueue, boolean bl) {
            if (bl && !this.ignoreNextFlush) {
                this.online = !this.online;
            }
        }

        public static interface OnlineEventsBridgeModeDelegate {
            public void setNetworkAvailable(boolean var1);

            public void runOnUiThread(Runnable var1);
        }
    }

    public static class LoadUrlBridgeMode
    extends BridgeMode {
        private final CordovaWebViewEngine engine;
        private final CordovaInterface cordova;

        public LoadUrlBridgeMode(CordovaWebViewEngine cordovaWebViewEngine, CordovaInterface cordovaInterface) {
            this.engine = cordovaWebViewEngine;
            this.cordova = cordovaInterface;
        }

        @Override
        public void onNativeToJsMessageAvailable(final NativeToJsMessageQueue nativeToJsMessageQueue) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String string2 = nativeToJsMessageQueue.popAndEncodeAsJs();
                    if (string2 != null) {
                        engine.loadUrl("javascript:" + string2, false);
                    }
                }
            });
        }
    }

    public static class NoOpBridgeMode
    extends BridgeMode {
        @Override
        public void onNativeToJsMessageAvailable(NativeToJsMessageQueue nativeToJsMessageQueue) {
        }
    }

    public static abstract class BridgeMode {
        public abstract void onNativeToJsMessageAvailable(NativeToJsMessageQueue var1);

        public void notifyOfFlush(NativeToJsMessageQueue nativeToJsMessageQueue, boolean bl) {
        }

        public void reset() {
        }
    }
}

