/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Debug;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.ICordovaClientCertRequest;
import org.apache.cordova.ICordovaHttpAuthHandler;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginResult;
import org.json.JSONException;

public class PluginManager {
    private static String TAG = "PluginManager";
    private static final int SLOW_EXEC_WARNING_THRESHOLD = Debug.isDebuggerConnected() ? 60 : 16;
    private final LinkedHashMap<String, CordovaPlugin> pluginMap = new LinkedHashMap();
    private final LinkedHashMap<String, PluginEntry> entryMap = new LinkedHashMap();
    private final CordovaInterface ctx;
    private final CordovaWebView app;
    private boolean isInitialized;
    private CordovaPlugin permissionRequester;

    public PluginManager(CordovaWebView cordovaWebView, CordovaInterface cordovaInterface, Collection<PluginEntry> collection) {
        this.ctx = cordovaInterface;
        this.app = cordovaWebView;
        this.setPluginEntries(collection);
    }

    public Collection<PluginEntry> getPluginEntries() {
        return this.entryMap.values();
    }

    public void setPluginEntries(Collection<PluginEntry> collection) {
        if (this.isInitialized) {
            this.onPause(false);
            this.onDestroy();
            this.pluginMap.clear();
            this.entryMap.clear();
        }
        for (PluginEntry pluginEntry : collection) {
            this.addService(pluginEntry);
        }
        if (this.isInitialized) {
            this.startupPlugins();
        }
    }

    public void init() {
        LOG.d(TAG, "init()");
        this.isInitialized = true;
        this.onPause(false);
        this.onDestroy();
        this.pluginMap.clear();
        this.startupPlugins();
    }

    private void startupPlugins() {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            if (pluginEntry.onload) {
                this.getPlugin(pluginEntry.service);
                continue;
            }
            this.pluginMap.put(pluginEntry.service, null);
        }
    }

    public void exec(String string2, String string3, String string4, String string5) {
        CordovaPlugin cordovaPlugin = this.getPlugin(string2);
        if (cordovaPlugin == null) {
            LOG.d(TAG, "exec() call to unknown plugin: " + string2);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.CLASS_NOT_FOUND_EXCEPTION);
            this.app.sendPluginResult(pluginResult, string4);
            return;
        }
        CallbackContext callbackContext = new CallbackContext(string4, this.app);
        try {
            long l2 = System.currentTimeMillis();
            boolean bl = cordovaPlugin.execute(string3, string5, callbackContext);
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > (long)SLOW_EXEC_WARNING_THRESHOLD) {
                LOG.w(TAG, "THREAD WARNING: exec() call to " + string2 + "." + string3 + " blocked the main thread for " + l3 + "ms. Plugin should use CordovaInterface.getThreadPool().");
            }
            if (!bl) {
                PluginResult pluginResult = new PluginResult(PluginResult.Status.INVALID_ACTION);
                callbackContext.sendPluginResult(pluginResult);
            }
        }
        catch (JSONException jSONException) {
            PluginResult pluginResult = new PluginResult(PluginResult.Status.JSON_EXCEPTION);
            callbackContext.sendPluginResult(pluginResult);
        }
        catch (Exception exception) {
            LOG.e(TAG, "Uncaught exception from plugin", exception);
            callbackContext.error(exception.getMessage());
        }
    }

    public CordovaPlugin getPlugin(String string2) {
        CordovaPlugin cordovaPlugin = this.pluginMap.get(string2);
        if (cordovaPlugin == null) {
            PluginEntry pluginEntry = this.entryMap.get(string2);
            if (pluginEntry == null) {
                return null;
            }
            cordovaPlugin = pluginEntry.plugin != null ? pluginEntry.plugin : this.instantiatePlugin(pluginEntry.pluginClass);
            cordovaPlugin.privateInitialize(string2, this.ctx, this.app, this.app.getPreferences());
            this.pluginMap.put(string2, cordovaPlugin);
        }
        return cordovaPlugin;
    }

    public void addService(String string2, String string3) {
        PluginEntry pluginEntry = new PluginEntry(string2, string3, false);
        this.addService(pluginEntry);
    }

    public void addService(PluginEntry pluginEntry) {
        this.entryMap.put(pluginEntry.service, pluginEntry);
        if (pluginEntry.plugin != null) {
            pluginEntry.plugin.privateInitialize(pluginEntry.service, this.ctx, this.app, this.app.getPreferences());
            this.pluginMap.put(pluginEntry.service, pluginEntry.plugin);
        }
    }

    public void onPause(boolean bl) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onPause(bl);
        }
    }

    public boolean onReceivedHttpAuthRequest(CordovaWebView cordovaWebView, ICordovaHttpAuthHandler iCordovaHttpAuthHandler, String string2, String string3) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null || !cordovaPlugin.onReceivedHttpAuthRequest(this.app, iCordovaHttpAuthHandler, string2, string3)) continue;
            return true;
        }
        return false;
    }

    public boolean onReceivedClientCertRequest(CordovaWebView cordovaWebView, ICordovaClientCertRequest iCordovaClientCertRequest) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null || !cordovaPlugin.onReceivedClientCertRequest(this.app, iCordovaClientCertRequest)) continue;
            return true;
        }
        return false;
    }

    public void onResume(boolean bl) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onResume(bl);
        }
    }

    public void onStart() {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onStart();
        }
    }

    public void onStop() {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onStop();
        }
    }

    public void onDestroy() {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onDestroy();
        }
    }

    public Object postMessage(String string2, Object object) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            Object object2;
            if (cordovaPlugin == null || (object2 = cordovaPlugin.onMessage(string2, object)) == null) continue;
            return object2;
        }
        return this.ctx.onMessage(string2, object);
    }

    public void onNewIntent(Intent intent) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onNewIntent(intent);
        }
    }

    public boolean shouldAllowRequest(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            Boolean bl;
            CordovaPlugin cordovaPlugin = this.pluginMap.get(pluginEntry.service);
            if (cordovaPlugin == null || (bl = cordovaPlugin.shouldAllowRequest(string2)) == null) continue;
            return bl;
        }
        if (string2.startsWith("blob:") || string2.startsWith("data:") || string2.startsWith("about:blank")) {
            return true;
        }
        if (string2.startsWith("https://ssl.gstatic.com/accessibility/javascript/android/")) {
            return true;
        }
        if (string2.startsWith("file://")) {
            return !string2.contains("/app_webview/");
        }
        return false;
    }

    public boolean shouldAllowNavigation(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            Boolean bl;
            CordovaPlugin cordovaPlugin = this.pluginMap.get(pluginEntry.service);
            if (cordovaPlugin == null || (bl = cordovaPlugin.shouldAllowNavigation(string2)) == null) continue;
            return bl;
        }
        return string2.startsWith("file://") || string2.startsWith("about:blank");
    }

    public boolean shouldAllowBridgeAccess(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            Boolean bl;
            CordovaPlugin cordovaPlugin = this.pluginMap.get(pluginEntry.service);
            if (cordovaPlugin == null || (bl = cordovaPlugin.shouldAllowBridgeAccess(string2)) == null) continue;
            return bl;
        }
        return string2.startsWith("file://");
    }

    public Boolean shouldOpenExternalUrl(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            Boolean bl;
            CordovaPlugin cordovaPlugin = this.pluginMap.get(pluginEntry.service);
            if (cordovaPlugin == null || (bl = cordovaPlugin.shouldOpenExternalUrl(string2)) == null) continue;
            return bl;
        }
        return false;
    }

    public boolean onOverrideUrlLoading(String string2) {
        for (PluginEntry pluginEntry : this.entryMap.values()) {
            CordovaPlugin cordovaPlugin = this.pluginMap.get(pluginEntry.service);
            if (cordovaPlugin == null || !cordovaPlugin.onOverrideUrlLoading(string2)) continue;
            return true;
        }
        return false;
    }

    public void onReset() {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onReset();
        }
    }

    Uri remapUri(Uri uri) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            Uri uri2;
            if (cordovaPlugin == null || (uri2 = cordovaPlugin.remapUri(uri)) == null) continue;
            return uri2;
        }
        return null;
    }

    private CordovaPlugin instantiatePlugin(String string2) {
        CordovaPlugin cordovaPlugin = null;
        try {
            Class<?> clazz = null;
            if (string2 != null && !"".equals(string2)) {
                clazz = Class.forName(string2);
            }
            if (clazz != null & CordovaPlugin.class.isAssignableFrom(clazz)) {
                cordovaPlugin = (CordovaPlugin)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error adding plugin " + string2 + ".");
        }
        return cordovaPlugin;
    }

    public void onConfigurationChanged(Configuration configuration) {
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            if (cordovaPlugin == null) continue;
            cordovaPlugin.onConfigurationChanged(configuration);
        }
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = new Bundle();
        for (CordovaPlugin cordovaPlugin : this.pluginMap.values()) {
            Bundle bundle2;
            if (cordovaPlugin == null || (bundle2 = cordovaPlugin.onSaveInstanceState()) == null) continue;
            bundle.putBundle(cordovaPlugin.getServiceName(), bundle2);
        }
        return bundle;
    }
}

