/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.camera;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.apache.cordova.CordovaInterface;

public class FileHelper {
    private static final String LOG_TAG = "FileUtils";
    private static final String _DATA = "_data";

    public static String getRealPath(Uri uri, CordovaInterface cordovaInterface) {
        String string2 = null;
        string2 = Build.VERSION.SDK_INT < 11 ? FileHelper.getRealPathFromURI_BelowAPI11((Context)cordovaInterface.getActivity(), uri) : FileHelper.getRealPathFromURI_API11_And_Above((Context)cordovaInterface.getActivity(), uri);
        return string2;
    }

    public static String getRealPath(String string2, CordovaInterface cordovaInterface) {
        return FileHelper.getRealPath(Uri.parse((String)string2), cordovaInterface);
    }

    @SuppressLint(value={"NewApi"})
    public static String getRealPathFromURI_API11_And_Above(Context context, Uri uri) {
        boolean bl;
        boolean bl2 = bl = Build.VERSION.SDK_INT >= 19;
        if (bl && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileHelper.isExternalStorageDocument(uri)) {
                String string2 = DocumentsContract.getDocumentId((Uri)uri);
                String[] stringArray = string2.split(":");
                String string3 = stringArray[0];
                if ("primary".equalsIgnoreCase(string3)) {
                    return Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                }
            } else {
                if (FileHelper.isDownloadsDocument(uri)) {
                    String string4 = DocumentsContract.getDocumentId((Uri)uri);
                    if (string4 != null && string4.length() > 0) {
                        if (string4.startsWith("raw:")) {
                            return string4.replaceFirst("raw:", "");
                        }
                        try {
                            Uri uri2 = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(string4));
                            return FileHelper.getDataColumn(context, uri2, null, null);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    }
                    return null;
                }
                if (FileHelper.isMediaDocument(uri)) {
                    String string5 = DocumentsContract.getDocumentId((Uri)uri);
                    String[] stringArray = string5.split(":");
                    String string6 = stringArray[0];
                    Uri uri3 = null;
                    if ("image".equals(string6)) {
                        uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(string6)) {
                        uri3 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(string6)) {
                        uri3 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String string7 = "_id=?";
                    String[] stringArray2 = new String[]{stringArray[1]};
                    return FileHelper.getDataColumn(context, uri3, "_id=?", stringArray2);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (FileHelper.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return FileHelper.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    public static String getRealPathFromURI_BelowAPI11(Context context, Uri uri) {
        String[] stringArray = new String[]{_DATA};
        String string2 = null;
        try {
            Cursor cursor = context.getContentResolver().query(uri, stringArray, null, null, null);
            int n2 = cursor.getColumnIndexOrThrow(_DATA);
            cursor.moveToFirst();
            string2 = cursor.getString(n2);
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    public static InputStream getInputStreamFromUriString(String string2, CordovaInterface cordovaInterface) {
        InputStream inputStream = null;
        if (string2.startsWith("content")) {
            Uri uri = Uri.parse((String)string2);
            inputStream = cordovaInterface.getActivity().getContentResolver().openInputStream(uri);
        } else if (string2.startsWith("file://")) {
            int n2 = string2.indexOf("?");
            if (n2 > -1) {
                string2 = string2.substring(0, n2);
            }
            if (string2.startsWith("file:///android_asset/")) {
                Uri uri = Uri.parse((String)string2);
                String string3 = uri.getPath().substring(15);
                inputStream = cordovaInterface.getActivity().getAssets().open(string3);
            } else {
                try {
                    inputStream = cordovaInterface.getActivity().getContentResolver().openInputStream(Uri.parse((String)string2));
                }
                catch (Exception exception) {
                    inputStream = null;
                }
                if (inputStream == null) {
                    inputStream = new FileInputStream(FileHelper.getRealPath(string2, cordovaInterface));
                }
            }
        } else {
            inputStream = new FileInputStream(string2);
        }
        return inputStream;
    }

    public static String stripFileProtocol(String string2) {
        if (string2.startsWith("file://")) {
            string2 = string2.substring(7);
        }
        return string2;
    }

    public static String getMimeTypeForExtension(String string2) {
        String string3 = string2;
        int n2 = string3.lastIndexOf(46);
        if (n2 != -1) {
            string3 = string3.substring(n2 + 1);
        }
        if ((string3 = string3.toLowerCase(Locale.getDefault())).equals("3ga")) {
            return "audio/3gpp";
        }
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
    }

    public static String getMimeType(String string2, CordovaInterface cordovaInterface) {
        String string3 = null;
        Uri uri = Uri.parse((String)string2);
        string3 = string2.startsWith("content://") ? cordovaInterface.getActivity().getContentResolver().getType(uri) : FileHelper.getMimeTypeForExtension(uri.getPath());
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String string2, String[] stringArray) {
        Cursor cursor = null;
        String string3 = _DATA;
        String[] stringArray2 = new String[]{_DATA};
        try {
            cursor = context.getContentResolver().query(uri, stringArray2, string2, stringArray, null);
            if (cursor != null && cursor.moveToFirst()) {
                int n2 = cursor.getColumnIndexOrThrow(_DATA);
                String string4 = cursor.getString(n2);
                return string4;
            }
        }
        catch (Exception exception) {
            String string5 = null;
            return string5;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }
}

