/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.annotation.TargetApi;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.cordova.AuthenticationToken;
import org.apache.cordova.CordovaClientCertRequest;
import org.apache.cordova.CordovaHttpAuthHandler;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.engine.SystemWebViewEngine;

public class SystemWebViewClient
extends WebViewClient {
    private static final String TAG = "SystemWebViewClient";
    protected final SystemWebViewEngine parentEngine;
    private boolean doClearHistory = false;
    boolean isCurrentlyLoading;
    private Hashtable<String, AuthenticationToken> authenticationTokens = new Hashtable();

    public SystemWebViewClient(SystemWebViewEngine systemWebViewEngine) {
        this.parentEngine = systemWebViewEngine;
    }

    public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        return this.parentEngine.client.onNavigationAttempt(string2);
    }

    public void onReceivedHttpAuthRequest(WebView webView, HttpAuthHandler httpAuthHandler, String string2, String string3) {
        AuthenticationToken authenticationToken = this.getAuthenticationToken(string2, string3);
        if (authenticationToken != null) {
            httpAuthHandler.proceed(authenticationToken.getUserName(), authenticationToken.getPassword());
            return;
        }
        PluginManager pluginManager = this.parentEngine.pluginManager;
        if (pluginManager != null && pluginManager.onReceivedHttpAuthRequest(null, new CordovaHttpAuthHandler(httpAuthHandler), string2, string3)) {
            this.parentEngine.client.clearLoadTimeoutTimer();
            return;
        }
        super.onReceivedHttpAuthRequest(webView, httpAuthHandler, string2, string3);
    }

    @TargetApi(value=21)
    public void onReceivedClientCertRequest(WebView webView, ClientCertRequest clientCertRequest) {
        PluginManager pluginManager = this.parentEngine.pluginManager;
        if (pluginManager != null && pluginManager.onReceivedClientCertRequest(null, new CordovaClientCertRequest(clientCertRequest))) {
            this.parentEngine.client.clearLoadTimeoutTimer();
            return;
        }
        super.onReceivedClientCertRequest(webView, clientCertRequest);
    }

    public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
        super.onPageStarted(webView, string2, bitmap);
        this.isCurrentlyLoading = true;
        this.parentEngine.bridge.reset();
        this.parentEngine.client.onPageStarted(string2);
    }

    public void onPageFinished(WebView webView, String string2) {
        super.onPageFinished(webView, string2);
        if (!this.isCurrentlyLoading && !string2.startsWith("about:")) {
            return;
        }
        this.isCurrentlyLoading = false;
        if (this.doClearHistory) {
            webView.clearHistory();
            this.doClearHistory = false;
        }
        this.parentEngine.client.onPageFinishedLoading(string2);
    }

    public void onReceivedError(WebView webView, int n2, String string2, String string3) {
        if (!this.isCurrentlyLoading) {
            return;
        }
        LOG.d(TAG, "CordovaWebViewClient.onReceivedError: Error code=%s Description=%s URL=%s", n2, string2, string3);
        if (n2 == -10) {
            this.parentEngine.client.clearLoadTimeoutTimer();
            if (webView.canGoBack()) {
                webView.goBack();
                return;
            }
            super.onReceivedError(webView, n2, string2, string3);
        }
        this.parentEngine.client.onReceivedError(n2, string2, string3);
    }

    public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
        String string2 = this.parentEngine.cordova.getActivity().getPackageName();
        PackageManager packageManager = this.parentEngine.cordova.getActivity().getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string2, 128);
            if ((applicationInfo.flags & 2) != 0) {
                sslErrorHandler.proceed();
                return;
            }
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
        }
    }

    public void setAuthenticationToken(AuthenticationToken authenticationToken, String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        this.authenticationTokens.put(string2.concat(string3), authenticationToken);
    }

    public AuthenticationToken removeAuthenticationToken(String string2, String string3) {
        return this.authenticationTokens.remove(string2.concat(string3));
    }

    public AuthenticationToken getAuthenticationToken(String string2, String string3) {
        AuthenticationToken authenticationToken = null;
        authenticationToken = this.authenticationTokens.get(string2.concat(string3));
        if (authenticationToken == null) {
            authenticationToken = this.authenticationTokens.get(string2);
            if (authenticationToken == null) {
                authenticationToken = this.authenticationTokens.get(string3);
            }
            if (authenticationToken == null) {
                authenticationToken = this.authenticationTokens.get("");
            }
        }
        return authenticationToken;
    }

    public void clearAuthenticationTokens() {
        this.authenticationTokens.clear();
    }

    public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
        try {
            Uri uri;
            if (!this.parentEngine.pluginManager.shouldAllowRequest(string2)) {
                LOG.w(TAG, "URL blocked by whitelist: " + string2);
                return new WebResourceResponse("text/plain", "UTF-8", null);
            }
            CordovaResourceApi cordovaResourceApi = this.parentEngine.resourceApi;
            Uri uri2 = Uri.parse((String)string2);
            if (!uri2.equals((Object)(uri = cordovaResourceApi.remapUri(uri2))) || SystemWebViewClient.needsSpecialsInAssetUrlFix(uri2) || SystemWebViewClient.needsKitKatContentUrlFix(uri2)) {
                CordovaResourceApi.OpenForReadResult openForReadResult = cordovaResourceApi.openForRead(uri, true);
                return new WebResourceResponse(openForReadResult.mimeType, "UTF-8", openForReadResult.inputStream);
            }
            return null;
        }
        catch (IOException iOException) {
            if (!(iOException instanceof FileNotFoundException)) {
                LOG.e(TAG, "Error occurred while loading a file (returning a 404).", iOException);
            }
            return new WebResourceResponse("text/plain", "UTF-8", null);
        }
    }

    private static boolean needsKitKatContentUrlFix(Uri uri) {
        return "content".equals(uri.getScheme());
    }

    private static boolean needsSpecialsInAssetUrlFix(Uri uri) {
        if (CordovaResourceApi.getUriType(uri) != 1) {
            return false;
        }
        if (uri.getQuery() != null || uri.getFragment() != null) {
            return true;
        }
        if (!uri.toString().contains("%")) {
            return false;
        }
        return false;
    }
}

