/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.view.View;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import org.apache.cordova.CordovaBridge;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.ICordovaCookieManager;
import org.apache.cordova.LOG;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginManager;
import org.apache.cordova.engine.SystemCookieManager;
import org.apache.cordova.engine.SystemExposedJsApi;
import org.apache.cordova.engine.SystemWebView;

public class SystemWebViewEngine
implements CordovaWebViewEngine {
    public static final String TAG = "SystemWebViewEngine";
    protected final SystemWebView webView;
    protected final SystemCookieManager cookieManager;
    protected CordovaPreferences preferences;
    protected CordovaBridge bridge;
    protected CordovaWebViewEngine.Client client;
    protected CordovaWebView parentWebView;
    protected CordovaInterface cordova;
    protected PluginManager pluginManager;
    protected CordovaResourceApi resourceApi;
    protected NativeToJsMessageQueue nativeToJsMessageQueue;
    private BroadcastReceiver receiver;

    public SystemWebViewEngine(Context context, CordovaPreferences cordovaPreferences) {
        this(new SystemWebView(context), cordovaPreferences);
    }

    public SystemWebViewEngine(SystemWebView systemWebView) {
        this(systemWebView, null);
    }

    public SystemWebViewEngine(SystemWebView systemWebView, CordovaPreferences cordovaPreferences) {
        this.preferences = cordovaPreferences;
        this.webView = systemWebView;
        this.cookieManager = new SystemCookieManager(systemWebView);
    }

    @Override
    public void init(CordovaWebView cordovaWebView, CordovaInterface cordovaInterface, CordovaWebViewEngine.Client client, CordovaResourceApi cordovaResourceApi, PluginManager pluginManager, NativeToJsMessageQueue nativeToJsMessageQueue) {
        if (this.cordova != null) {
            throw new IllegalStateException();
        }
        if (this.preferences == null) {
            this.preferences = cordovaWebView.getPreferences();
        }
        this.parentWebView = cordovaWebView;
        this.cordova = cordovaInterface;
        this.client = client;
        this.resourceApi = cordovaResourceApi;
        this.pluginManager = pluginManager;
        this.nativeToJsMessageQueue = nativeToJsMessageQueue;
        this.webView.init(this, cordovaInterface);
        this.initWebViewSettings();
        nativeToJsMessageQueue.addBridgeMode(new NativeToJsMessageQueue.OnlineEventsBridgeMode(new NativeToJsMessageQueue.OnlineEventsBridgeMode.OnlineEventsBridgeModeDelegate(){

            @Override
            public void setNetworkAvailable(boolean bl) {
                if (SystemWebViewEngine.this.webView != null) {
                    SystemWebViewEngine.this.webView.setNetworkAvailable(bl);
                }
            }

            @Override
            public void runOnUiThread(Runnable runnable) {
                SystemWebViewEngine.this.cordova.getActivity().runOnUiThread(runnable);
            }
        }));
        nativeToJsMessageQueue.addBridgeMode(new NativeToJsMessageQueue.EvalBridgeMode(this, cordovaInterface));
        this.bridge = new CordovaBridge(pluginManager, nativeToJsMessageQueue);
        SystemWebViewEngine.exposeJsInterface(this.webView, this.bridge);
    }

    @Override
    public CordovaWebView getCordovaWebView() {
        return this.parentWebView;
    }

    @Override
    public ICordovaCookieManager getCookieManager() {
        return this.cookieManager;
    }

    @Override
    public View getView() {
        return this.webView;
    }

    @SuppressLint(value={"NewApi", "SetJavaScriptEnabled"})
    private void initWebViewSettings() {
        String string2;
        this.webView.setInitialScale(0);
        this.webView.setVerticalScrollBarEnabled(false);
        final WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        String string3 = Build.MANUFACTURER;
        LOG.d(TAG, "CordovaWebView is running on device made by: " + string3);
        webSettings.setSaveFormData(false);
        webSettings.setSavePassword(false);
        webSettings.setAllowUniversalAccessFromFileURLs(true);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        String string4 = this.webView.getContext().getApplicationContext().getDir("database", 0).getPath();
        webSettings.setDatabaseEnabled(true);
        webSettings.setDatabasePath(string4);
        ApplicationInfo applicationInfo = this.webView.getContext().getApplicationContext().getApplicationInfo();
        if ((applicationInfo.flags & 2) != 0) {
            this.enableRemoteDebugging();
        }
        webSettings.setGeolocationDatabasePath(string4);
        webSettings.setDomStorageEnabled(true);
        webSettings.setGeolocationEnabled(true);
        webSettings.setAppCacheMaxSize(0x500000L);
        webSettings.setAppCachePath(string4);
        webSettings.setAppCacheEnabled(true);
        String string5 = webSettings.getUserAgentString();
        String string6 = this.preferences.getString("OverrideUserAgent", null);
        if (string6 != null) {
            webSettings.setUserAgentString(string6);
        } else {
            string2 = this.preferences.getString("AppendUserAgent", null);
            if (string2 != null) {
                webSettings.setUserAgentString(string5 + " " + string2);
            }
        }
        string2 = new IntentFilter();
        string2.addAction("android.intent.action.CONFIGURATION_CHANGED");
        if (this.receiver == null) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    webSettings.getUserAgentString();
                }
            };
            this.webView.getContext().registerReceiver(this.receiver, (IntentFilter)string2);
        }
    }

    private void enableRemoteDebugging() {
        try {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.d(TAG, "You have one job! To turn on Remote Web Debugging! YOU HAVE FAILED! ");
            illegalArgumentException.printStackTrace();
        }
    }

    @SuppressLint(value={"AddJavascriptInterface"})
    private static void exposeJsInterface(WebView webView, CordovaBridge cordovaBridge) {
        SystemExposedJsApi systemExposedJsApi = new SystemExposedJsApi(cordovaBridge);
        webView.addJavascriptInterface((Object)systemExposedJsApi, "_cordovaNative");
    }

    @Override
    public void loadUrl(String string2, boolean bl) {
        this.webView.loadUrl(string2);
    }

    @Override
    public String getUrl() {
        return this.webView.getUrl();
    }

    @Override
    public void stopLoading() {
        this.webView.stopLoading();
    }

    @Override
    public void clearCache() {
        this.webView.clearCache(true);
    }

    @Override
    public void clearHistory() {
        this.webView.clearHistory();
    }

    @Override
    public boolean canGoBack() {
        return this.webView.canGoBack();
    }

    @Override
    public boolean goBack() {
        if (this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return false;
    }

    @Override
    public void setPaused(boolean bl) {
        if (bl) {
            this.webView.onPause();
            this.webView.pauseTimers();
        } else {
            this.webView.onResume();
            this.webView.resumeTimers();
        }
    }

    @Override
    public void destroy() {
        this.webView.chromeClient.destroyLastDialog();
        this.webView.destroy();
        if (this.receiver != null) {
            try {
                this.webView.getContext().unregisterReceiver(this.receiver);
            }
            catch (Exception exception) {
                LOG.e(TAG, "Error unregistering configuration receiver: " + exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        this.webView.evaluateJavascript(string2, valueCallback);
    }
}

