/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.splashscreen;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.json.JSONArray;

public class SplashScreen
extends CordovaPlugin {
    private static final String LOG_TAG = "SplashScreen";
    private static final boolean HAS_BUILT_IN_SPLASH_SCREEN = Integer.valueOf("8.1.0".split("\\.")[0]) < 4;
    private static final int DEFAULT_SPLASHSCREEN_DURATION = 3000;
    private static final int DEFAULT_FADE_DURATION = 500;
    private static Dialog splashDialog;
    private static ProgressDialog spinnerDialog;
    private static boolean firstShow;
    private static boolean lastHideAfterDelay;
    private ImageView splashImageView;
    private int orientation;

    private View getView() {
        try {
            return (View)this.webView.getClass().getMethod("getView", new Class[0]).invoke((Object)this.webView, new Object[0]);
        }
        catch (Exception exception) {
            return (View)this.webView;
        }
    }

    private int getSplashId() {
        int n2 = 0;
        String string2 = this.preferences.getString(LOG_TAG, "screen");
        if (string2 != null && (n2 = this.cordova.getActivity().getResources().getIdentifier(string2, "drawable", this.cordova.getActivity().getClass().getPackage().getName())) == 0) {
            n2 = this.cordova.getActivity().getResources().getIdentifier(string2, "drawable", this.cordova.getActivity().getPackageName());
        }
        return n2;
    }

    @Override
    protected void pluginInitialize() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    SplashScreen.this.getView().setBackgroundColor(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private boolean isMaintainAspectRatio() {
        return this.preferences.getBoolean("SplashMaintainAspectRatio", false);
    }

    private int getFadeDuration() {
        int n2;
        int n3 = n2 = this.preferences.getBoolean("FadeSplashScreen", true) ? this.preferences.getInteger("FadeSplashScreenDuration", 500) : 0;
        if (n2 < 30) {
            n2 *= 1000;
        }
        return n2;
    }

    @Override
    public void onPause(boolean bl) {
        if (HAS_BUILT_IN_SPLASH_SCREEN) {
            return;
        }
        this.removeSplashScreen(true);
    }

    @Override
    public void onDestroy() {
        if (HAS_BUILT_IN_SPLASH_SCREEN) {
            return;
        }
        this.removeSplashScreen(true);
    }

    @Override
    public boolean execute(String string2, JSONArray jSONArray, CallbackContext callbackContext) {
        if (string2.equals("hide")) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.this.webView.postMessage("splashscreen", "hide");
                }
            });
        } else if (string2.equals("show")) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.this.webView.postMessage("splashscreen", "show");
                }
            });
        } else {
            return false;
        }
        callbackContext.success();
        return true;
    }

    @Override
    public Object onMessage(String string2, Object object) {
        if (HAS_BUILT_IN_SPLASH_SCREEN) {
            return null;
        }
        if ("splashscreen".equals(string2)) {
            if ("hide".equals(object.toString())) {
                this.removeSplashScreen(false);
            } else {
                this.showSplashScreen(false);
            }
        } else if ("spinner".equals(string2)) {
            if ("stop".equals(object.toString())) {
                this.getView().setVisibility(0);
            }
        } else if ("onReceivedError".equals(string2)) {
            this.spinnerStop();
        }
        return null;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        if (configuration.orientation != this.orientation) {
            int n2;
            this.orientation = configuration.orientation;
            if (this.splashImageView != null && (n2 = this.getSplashId()) != 0) {
                this.splashImageView.setImageDrawable(this.cordova.getActivity().getResources().getDrawable(n2));
            }
        }
    }

    private void removeSplashScreen(final boolean bl) {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (splashDialog != null && SplashScreen.this.splashImageView != null && splashDialog.isShowing()) {
                    int n2 = SplashScreen.this.getFadeDuration();
                    if (n2 > 0 && !bl) {
                        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
                        alphaAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
                        alphaAnimation.setDuration((long)n2);
                        SplashScreen.this.splashImageView.setAnimation((Animation)alphaAnimation);
                        SplashScreen.this.splashImageView.startAnimation((Animation)alphaAnimation);
                        alphaAnimation.setAnimationListener(new Animation.AnimationListener(){

                            public void onAnimationStart(Animation animation) {
                                SplashScreen.this.spinnerStop();
                            }

                            public void onAnimationEnd(Animation animation) {
                                if (splashDialog != null && SplashScreen.this.splashImageView != null && splashDialog.isShowing()) {
                                    splashDialog.dismiss();
                                    splashDialog = null;
                                    SplashScreen.this.splashImageView = null;
                                }
                            }

                            public void onAnimationRepeat(Animation animation) {
                            }
                        });
                    } else {
                        SplashScreen.this.spinnerStop();
                        splashDialog.dismiss();
                        splashDialog = null;
                        SplashScreen.this.splashImageView = null;
                    }
                }
            }
        });
    }

    private void showSplashScreen(final boolean bl) {
        int n2 = this.preferences.getInteger("SplashScreenDelay", 3000);
        final int n3 = this.getSplashId();
        int n4 = this.getFadeDuration();
        final int n5 = Math.max(0, n2 - n4);
        lastHideAfterDelay = bl;
        if (this.cordova.getActivity().isFinishing()) {
            return;
        }
        if (splashDialog != null && splashDialog.isShowing()) {
            return;
        }
        if (n3 == 0 || n2 <= 0 && bl) {
            return;
        }
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Display display = SplashScreen.this.cordova.getActivity().getWindowManager().getDefaultDisplay();
                Context context = SplashScreen.this.webView.getContext();
                SplashScreen.this.splashImageView = new ImageView(context);
                SplashScreen.this.splashImageView.setImageResource(n3);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
                SplashScreen.this.splashImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                SplashScreen.this.splashImageView.setMinimumHeight(display.getHeight());
                SplashScreen.this.splashImageView.setMinimumWidth(display.getWidth());
                SplashScreen.this.splashImageView.setBackgroundColor(SplashScreen.this.preferences.getInteger("backgroundColor", -16777216));
                if (SplashScreen.this.isMaintainAspectRatio()) {
                    SplashScreen.this.splashImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                } else {
                    SplashScreen.this.splashImageView.setScaleType(ImageView.ScaleType.FIT_XY);
                }
                splashDialog = new Dialog(context, 0x1030010);
                if ((SplashScreen.this.cordova.getActivity().getWindow().getAttributes().flags & 0x400) == 1024) {
                    splashDialog.getWindow().setFlags(1024, 1024);
                }
                splashDialog.setContentView((View)SplashScreen.this.splashImageView);
                splashDialog.setCancelable(false);
                splashDialog.show();
                if (SplashScreen.this.preferences.getBoolean("ShowSplashScreenSpinner", true)) {
                    SplashScreen.this.spinnerStart();
                }
                if (bl) {
                    Handler handler = new Handler();
                    handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (lastHideAfterDelay) {
                                SplashScreen.this.removeSplashScreen(false);
                            }
                        }
                    }, (long)n5);
                }
            }
        });
    }

    private void spinnerStart() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String string2;
                SplashScreen.this.spinnerStop();
                spinnerDialog = new ProgressDialog(SplashScreen.this.webView.getContext());
                spinnerDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        spinnerDialog = null;
                    }
                });
                spinnerDialog.setCancelable(false);
                spinnerDialog.setIndeterminate(true);
                RelativeLayout relativeLayout = new RelativeLayout((Context)SplashScreen.this.cordova.getActivity());
                relativeLayout.setGravity(17);
                relativeLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
                ProgressBar progressBar = new ProgressBar(SplashScreen.this.webView.getContext());
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(13, -1);
                progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (Build.VERSION.SDK_INT >= 21 && (string2 = SplashScreen.this.preferences.getString("SplashScreenSpinnerColor", null)) != null) {
                    int[][] nArrayArray = new int[][]{{16842910}, {-16842910}, {-16842912}, {16842919}};
                    int n2 = Color.parseColor((String)string2);
                    int[] nArray = new int[]{n2, n2, n2, n2};
                    ColorStateList colorStateList = new ColorStateList((int[][])nArrayArray, nArray);
                    progressBar.setIndeterminateTintList(colorStateList);
                }
                relativeLayout.addView((View)progressBar);
                spinnerDialog.getWindow().clearFlags(2);
                spinnerDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
                spinnerDialog.show();
                spinnerDialog.setContentView((View)relativeLayout);
            }
        });
    }

    private void spinnerStop() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (spinnerDialog != null && spinnerDialog.isShowing()) {
                    spinnerDialog.dismiss();
                    spinnerDialog = null;
                }
            }
        });
    }

    static {
        firstShow = true;
    }
}

