/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.statusbar;

import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.Window;
import java.util.Arrays;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.json.JSONException;

public class StatusBar
extends CordovaPlugin {
    @Override
    public void initialize(final CordovaInterface cordovaInterface, CordovaWebView cordovaWebView) {
        super.initialize(cordovaInterface, cordovaWebView);
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Window window = cordovaInterface.getActivity().getWindow();
                window.clearFlags(2048);
                StatusBar.this.setStatusBarBackgroundColor(StatusBar.this.preferences.getString("StatusBarBackgroundColor", "#000000"));
                StatusBar.this.setStatusBarStyle(StatusBar.this.preferences.getString("StatusBarStyle", "lightcontent"));
                LOG.e("LukeLauncher", "Init Statusbar");
            }
        });
    }

    @Override
    public boolean execute(String string2, final CordovaArgs cordovaArgs, CallbackContext callbackContext) {
        Activity activity = this.cordova.getActivity();
        final Window window = activity.getWindow();
        if ("_ready".equals(string2)) {
            boolean bl = (window.getAttributes().flags & 0x400) == 0;
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, bl));
            return true;
        }
        if ("show".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 19) {
                        int n2 = window.getDecorView().getSystemUiVisibility();
                        n2 &= 0xFFFFFBFF;
                        window.getDecorView().setSystemUiVisibility(n2 &= 0xFFFFFFFB);
                    }
                    window.clearFlags(1024);
                }
            });
            return true;
        }
        if ("hide".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 19) {
                        int n2 = window.getDecorView().getSystemUiVisibility() | 0x400 | 4;
                        window.getDecorView().setSystemUiVisibility(n2);
                    }
                    window.addFlags(1024);
                }
            });
            return true;
        }
        if ("backgroundColorByHexString".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatusBar.this.setStatusBarBackgroundColor(cordovaArgs.getString(0));
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        if ("overlaysWebView".equals(string2)) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.cordova.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            StatusBar.this.setStatusBarTransparent(cordovaArgs.getBoolean(0));
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                });
                return true;
            }
            return !cordovaArgs.getBoolean(0);
        }
        if ("styleDefault".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.setStatusBarStyle("default");
                }
            });
            return true;
        }
        if ("styleLightContent".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.setStatusBarStyle("lightcontent");
                }
            });
            return true;
        }
        if ("styleBlackTranslucent".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.setStatusBarStyle("blacktranslucent");
                }
            });
            return true;
        }
        if ("styleBlackOpaque".equals(string2)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.setStatusBarStyle("blackopaque");
                }
            });
            return true;
        }
        return false;
    }

    private void setStatusBarBackgroundColor(String string2) {
        if (Build.VERSION.SDK_INT >= 21 && string2 != null && !string2.isEmpty()) {
            Window window = this.cordova.getActivity().getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            try {
                window.getClass().getMethod("setStatusBarColor", Integer.TYPE).invoke((Object)window, Color.parseColor((String)string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setStatusBarTransparent(boolean bl) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.cordova.getActivity().getWindow();
            if (bl) {
                window.getDecorView().setSystemUiVisibility(1280);
                window.setStatusBarColor(0);
            } else {
                window.getDecorView().setSystemUiVisibility(256);
            }
        }
    }

    private void setStatusBarStyle(String string2) {
        if (Build.VERSION.SDK_INT >= 23 && string2 != null && !string2.isEmpty()) {
            View view = this.cordova.getActivity().getWindow().getDecorView();
            int n2 = view.getSystemUiVisibility();
            String[] stringArray = new String[]{"default"};
            String[] stringArray2 = new String[]{"lightcontent", "blacktranslucent", "blackopaque"};
            if (Arrays.asList(stringArray).contains(string2.toLowerCase())) {
                view.setSystemUiVisibility(n2 | 0x2000);
                return;
            }
            if (Arrays.asList(stringArray2).contains(string2.toLowerCase())) {
                view.setSystemUiVisibility(n2 & 0xFFFFDFFF);
                return;
            }
        }
    }
}

